/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.certStore;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.certStore.CertStore;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCertStore
implements CertStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCertStore.class);

    protected byte[] getSubjectKeyIdentifier(X509Extension cert) {
        byte[] extensionValue = cert.getExtensionValue("2.5.29.14");
        if (extensionValue != null) {
            try {
                OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(extensionValue)));
                extensionValue = o.getOctets();
            }
            catch (ParseException e) {
                LOGGER.debug("CRLDistPoint is not encoded in octet string");
            }
            try {
                SubjectKeyIdentifier ski = SubjectKeyIdentifier.getInstance((Object)extensionValue);
                return ski.getKeyIdentifier();
            }
            catch (Exception e) {
                LOGGER.debug("Cannot parse subject key identifier", (Throwable)e);
            }
        }
        return null;
    }

    protected byte[] getAuthorityKeyIdentifierBytes(X509Extension cert) {
        AuthorityKeyIdentifier authorityKeyIdentifier = this.getAuthorityKeyIdentifier(cert);
        if (authorityKeyIdentifier != null) {
            return authorityKeyIdentifier.getKeyIdentifier();
        }
        return null;
    }

    protected AuthorityKeyIdentifier getAuthorityKeyIdentifier(X509Extension cert) {
        byte[] extensionValue = cert.getExtensionValue("2.5.29.35");
        if (extensionValue != null) {
            try {
                OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(extensionValue)));
                extensionValue = o.getOctets();
            }
            catch (ParseException e) {
                LOGGER.debug("CRLDistPoint is not encoded in octet string");
            }
            try {
                AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)extensionValue);
                return aki;
            }
            catch (Exception e) {
                LOGGER.debug("Cannot parse authority key identifier", (Throwable)e);
            }
        }
        return null;
    }
}

