/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.tsp.CSLTimestampException;
import de.governikus.csl.tsp.RFCTimestampRequestGenerator;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginCategoryType;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.impl.AbstractPlugin;
import de.governikus.csl.uom.tsp.TimestampConfiguration;
import de.governikus.csl.uom.tsp.TimestampOptions;
import de.governikus.csl.uom.tsp.TimestampPlugin;
import de.governikus.csl.uom.tsp.TimestampRequest;
import de.governikus.csl.uom.tsp.TimestampResponse;
import de.governikus.csl.uom.util.Environment;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TimeStampRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@PluginType(id=Plugin.PluginID.TIMESTAMP, type=TimestampPlugin.class)
@PluginCategoryType(id=Plugin.PluginCategoryID.TIMESTAMP, type=TimestampPlugin.class)
public class TimestampPluginImpl
extends AbstractPlugin
implements TimestampPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampPluginImpl.class);
    private boolean enabled = false;
    private static final ASN1ObjectIdentifier ETSI_TSA_BASELINE_POLICY_IDENTIFIER = new ASN1ObjectIdentifier("0.4.0.2023.1.1");
    private static final ASN1ObjectIdentifier ETSI_TSA_BASELINE_POLICY_IDENTIFIER_2 = new ASN1ObjectIdentifier("1.3.6.1.4.1.12655.3.2");
    private ASN1ObjectIdentifier policy = ETSI_TSA_BASELINE_POLICY_IDENTIFIER;
    private InstanceProvider instanceProvider;
    private TimestampConfiguration configuration;

    private TimeStampRequest createRFC3161TimestampRequestForDocument(TimestampRequest timestampRequest) throws CoreException {
        try {
            byte[] digest;
            TimestampOptions to = (TimestampOptions)timestampRequest.getOptions();
            RFCTimestampRequestGenerator gen = new RFCTimestampRequestGenerator();
            DigestAlgorithm digestAlgorithm = to.getDigestAlgorithm();
            if (to.isHashed()) {
                digest = this.readDigest(timestampRequest.getDataToBeTimestamped());
                if (digestAlgorithm.getDigestSize() != digest.length) {
                    throw new IOException("\nAlgorithm does not support digest length of " + digest.length + "Byte.\nA length of " + digestAlgorithm.getDigestSize() + "Byte is needed.\nWrong hash algorithm? ");
                }
            } else {
                digest = this.digest(timestampRequest.getDataToBeTimestamped(), digestAlgorithm.getJCAName());
            }
            return gen.genReq(new ASN1ObjectIdentifier(digestAlgorithm.getOID()), digest, true, null);
        }
        catch (IOException | RuntimeException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CSLTimestampException(CSLTimestampException.Failure.TIMESTAMPING_PREPARE, e);
        }
    }

    public void initialize(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    /*
     * Exception decompiling
     */
    public TimestampResponse timestamp(TimestampRequest timestampRequest, Closeable transportClient, Environment env) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] digest(DataToBeSigned dtbs, String algo) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(algo, "BC");
        try (DigestOutputStream dos = new DigestOutputStream((OutputStream)new NullOutputStream(), messageDigest);){
            for (Document d : dtbs.getDocuments()) {
                InputStream is = d.getInputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)dos);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            Object object = dos.getMessageDigest().digest();
            return object;
        }
    }

    private byte[] readDigest(DataToBeSigned dtbs) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (Document d : dtbs.getDocuments()) {
                InputStream is = d.getInputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)baos);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            Object object = baos.toByteArray();
            return object;
        }
    }

    public byte[] getTimestampResponse(byte[] timestampRequest, Closeable transportClient, TimestampConfiguration tspConfig) throws CoreException {
        ResponseData responseData;
        block19: {
            URL serverUrl = tspConfig.getServerUrl();
            HashMap<String, Object> headerMap = new HashMap<String, Object>();
            headerMap.put("Content-Type", "application/timestamp-query");
            String serverUser = tspConfig.getServerUser();
            String serverPassword = tspConfig.getServerPassword();
            if (serverUser != null) {
                String encoding = Base64.getUrlEncoder().encodeToString((serverUser + ":" + serverPassword).getBytes());
                headerMap.put("Authorization", "Basic " + encoding);
            }
            boolean close = false;
            HttpClient client = null;
            if (transportClient instanceof HttpClient) {
                client = (HttpClient)transportClient;
            } else {
                close = true;
                TransportFactoryConfiguration transportconfig = new TransportFactoryConfiguration();
                int serverTimeout = tspConfig.getServerTimeout();
                if (serverTimeout > 0) {
                    transportconfig.setConnectionTimeout(serverTimeout);
                }
                try {
                    List trustedServerCerts = tspConfig.getTrustedServerCerts();
                    transportconfig.setTrustedServerCerts(trustedServerCerts);
                    if (tspConfig.isTLSClientAuthentication().booleanValue()) {
                        KeyStore clientKeyStore = tspConfig.getClientKeyStore();
                        String clientKeyStorePin = tspConfig.getClientKeyStorePin();
                        transportconfig.setClientKeystore(clientKeyStore);
                        transportconfig.setClientKeyPassword(clientKeyStorePin);
                    }
                    transportconfig.setProxyConfiguration(tspConfig.getProxyConfig());
                }
                catch (Exception e) {
                    throw new CSLTimestampException(CSLTimestampException.Failure.TIMESTAMPING_PREPARE, "Can't connect to timestamp server, connection preparation failed", e);
                }
                client = new ApacheHttpClient(transportconfig);
            }
            LOG.debug("server url : {}", (Object)serverUrl);
            responseData = null;
            if (close) {
                try (HttpClient transportFactoryImpl = client;){
                    responseData = transportFactoryImpl.sendPOSTRequest(serverUrl.toString(), headerMap, timestampRequest);
                    break block19;
                }
                catch (Exception e) {
                    throw new CSLTimestampException(CSLTimestampException.Failure.TIMESTAMPING_FAILED, "Can't connect to timestamp server", e);
                }
            }
            try {
                responseData = client.sendPOSTRequest(serverUrl.toString(), headerMap, timestampRequest);
            }
            catch (Exception e) {
                throw new CSLTimestampException(CSLTimestampException.Failure.TIMESTAMPING_FAILED, "Can't connect to timestamp server", e);
            }
        }
        int responseHttpCode = responseData.getResponseHttpCode();
        if (responseHttpCode != 200) {
            String errorBodyAsString = new String(responseData.getResponse(), StandardCharsets.ISO_8859_1);
            throw new CSLTimestampException(CSLTimestampException.Failure.TIMESTAMPING_FAILED, "Can not reach remote timestamp server with response HttpCode " + responseHttpCode + " Details: " + errorBodyAsString);
        }
        return responseData.getResponse();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) throws IllegalStateException {
        this.enabled = enabled;
    }

    public void configure(TimestampConfiguration config) {
        this.configuration = config;
    }
}

