/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsp;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogs;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.tsp.RFCTimestampRequestGenerator;
import de.governikus.csl.tsp.TimestampResponseValidator;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFCTimestampResponseGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RFCTimestampResponseGenerator.class);
    private AlgorithmCatalogs algoCats;
    private String algoCat;

    public RFCTimestampResponseGenerator() {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                LOGGER.debug("BouncyCastleProvider registered.");
            } else {
                LOGGER.debug("BouncyCastleProvider already registered.");
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to register BouncyCastleProvider {}", (Object)e.getMessage());
        }
    }

    public void update(AlgorithmCatalogs algoCats, String algoCat) {
        this.algoCats = algoCats;
        this.algoCat = algoCat;
    }

    private Key getKey(KeyStore timeStampKeyStore, String alias, boolean priv) {
        PrivateKey issuerKey = null;
        PublicKey key = null;
        try {
            if (priv) {
                if (timeStampKeyStore.getKey(alias, null) == null) {
                    issuerKey = (PrivateKey)PrivateKey.class.cast(timeStampKeyStore.getKey(timeStampKeyStore.aliases().nextElement(), null));
                    LOGGER.warn("Requested key not in the keystore. Using key {}", (Object)issuerKey);
                } else {
                    issuerKey = (PrivateKey)PrivateKey.class.cast(timeStampKeyStore.getKey(alias, null));
                }
                return issuerKey;
            }
            if (timeStampKeyStore.getCertificate(alias) == null) {
                key = timeStampKeyStore.getCertificate(timeStampKeyStore.aliases().nextElement()).getPublicKey();
                LOGGER.warn("Requested key not in the keystore. Using key {}", (Object)key);
            } else {
                key = timeStampKeyStore.getCertificate(alias).getPublicKey();
            }
            return key;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOGGER.error("Failed to get signaute key:", (Throwable)e);
            return null;
        }
    }

    private TimeStampTokenGenerator createGenerator(KeyStore timeStampKeyStore, String alias, SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm, Set<ASN1ObjectIdentifier> policy) throws IllegalArgumentException, CertificateEncodingException, OperatorCreationException, TSPException {
        X509Certificate[] issuerCertificateChain = null;
        try {
            if (timeStampKeyStore.getCertificateChain(alias) == null) {
                alias = timeStampKeyStore.aliases().nextElement();
                LOGGER.warn("Requested key not in the keystore. Using key {}", (Object)alias);
            }
            issuerCertificateChain = Arrays.asList(timeStampKeyStore.getCertificateChain(alias)).toArray(new X509Certificate[0]);
        }
        catch (KeyStoreException e) {
            LOGGER.error("Failed to generate timestamp token", (Throwable)e);
            return null;
        }
        PrivateKey issuerKey = (PrivateKey)this.getKey(timeStampKeyStore, alias, true);
        return this.createGenerator(issuerKey, issuerCertificateChain, signatureAlgorithm, digestAlgorithm, policy);
    }

    private TimeStampTokenGenerator createGenerator(PrivateKey signerKey, X509Certificate[] signerCertificateChain, SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm, Set<ASN1ObjectIdentifier> policy) throws OperatorCreationException, CertificateEncodingException, IllegalArgumentException, TSPException {
        JcaSimpleSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(CryptoProviderUtil.PROVIDER);
        infoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) {
                Hashtable attributeTable = this.createStandardAttributeTable(parameters);
                attributeTable.remove(CMSAttributes.signingTime);
                return new AttributeTable(attributeTable);
            }
        });
        String signatureJCAName = signatureAlgorithm.getJCAName();
        List signatureForOIDs = AlgorithmService.getSignatureForOID((String)signatureAlgorithm.getOID());
        DefaultSignatureAlgorithmIdentifierFinder finder = new DefaultSignatureAlgorithmIdentifierFinder();
        for (SignatureAlgorithm signatureForOID : signatureForOIDs) {
            if (!signatureForOID.getName().equals(signatureAlgorithm.getName())) continue;
            try {
                signatureJCAName = signatureForOID.getJCAName();
                finder.find(signatureJCAName);
                break;
            }
            catch (Exception exception) {
                signatureJCAName = null;
            }
        }
        if (signatureJCAName == null) {
            return null;
        }
        TimeStampTokenGenerator tokenGenerator = new TimeStampTokenGenerator(infoGeneratorBuilder.build(signatureJCAName, signerKey, signerCertificateChain[0]), this.createDefaultDigestCalculator(digestAlgorithm), (ASN1ObjectIdentifier)policy.toArray()[0]);
        tokenGenerator.setResolution(0);
        LinkedList<JcaX509CertificateHolder> certHolderList = new LinkedList<JcaX509CertificateHolder>();
        for (int i = 0; i < signerCertificateChain.length; ++i) {
            certHolderList.add(new JcaX509CertificateHolder(signerCertificateChain[i]));
        }
        CollectionStore store = new CollectionStore(certHolderList);
        tokenGenerator.addCertificates((Store)store);
        return tokenGenerator;
    }

    private DigestCalculator createDefaultDigestCalculator(DigestAlgorithm digestAlgorithm) throws OperatorCreationException {
        return this.createDefaultDigestCalculatorProvider().get(new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithm.getOID())));
    }

    private DigestCalculatorProvider createDefaultDigestCalculatorProvider() throws OperatorCreationException {
        return this.createDefaultDigestCalculatorProviderBuilder().build();
    }

    private JcaDigestCalculatorProviderBuilder createDefaultDigestCalculatorProviderBuilder() {
        JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
        jcaDigestCalculatorProviderBuilder.setProvider(CryptoProviderUtil.PROVIDER);
        return jcaDigestCalculatorProviderBuilder;
    }

    public TimeStampResponse timestamp(KeyStore timestampServerKeyStore, String alias, SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm, Set<ASN1ObjectIdentifier> policy, byte[] requestBytes, BigInteger serialNumber, int accuracy) throws TSPException {
        Set<ASN1ObjectIdentifier> validAlgorithms;
        if (requestBytes == null) {
            LOGGER.error("Invalid request: request must not be null.");
            return this.createFailureResponse(policy, 2, 32, "Request must not be null.");
        }
        TimeStampRequest timeStampRequest = null;
        try {
            timeStampRequest = new TimeStampRequest(requestBytes);
        }
        catch (IOException e1) {
            LOGGER.error("Unable to parse request.");
            return this.createFailureResponse(policy, 2, 32, "Unable to parse request.");
        }
        if (timeStampRequest.getReqPolicy() != null && !policy.toArray()[0].equals(timeStampRequest.getReqPolicy())) {
            LOGGER.error("unsupported policy");
            return this.createFailureResponse(policy, 2, 256, "Policy: " + timeStampRequest.getReqPolicy().toString());
        }
        if (!timeStampRequest.getCriticalExtensionOIDs().isEmpty() || !timeStampRequest.getExtensionOIDs().isEmpty()) {
            LOGGER.error("unsupported extension");
            return this.createFailureResponse(policy, 2, 0x800000, "The requested extension is not supported.");
        }
        try {
            if (timestampServerKeyStore == null || timestampServerKeyStore.getCertificateChain(alias) == null) {
                LOGGER.info("Keystore does not contain requested alias.");
                return this.createFailureResponse(policy, 2, 0x40000000, "Bad keystore or alias");
            }
            X509Certificate[] issuerCertificateChain = Arrays.asList(timestampServerKeyStore.getCertificateChain(alias)).toArray(new X509Certificate[0]);
            X509CertificateHolder cert = new X509CertificateHolder(issuerCertificateChain[0].getEncoded());
            if (!this.validateExtendedKeyUsage(cert, new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping))) {
                LOGGER.info("Signing key not generated for signing timestamp.");
                return this.createFailureResponse(policy, 2, 0x40000000, "Bad Certificate");
            }
        }
        catch (IOException | KeyStoreException | CertificateEncodingException e2) {
            LOGGER.info("An error occured whilest validating key usage", (Throwable)e2);
            return this.createFailureResponse(policy, 2, 0x40000000, "Could not validate Certificate");
        }
        Date genTime = new Date();
        if ("NAN".equals(this.algoCat)) {
            validAlgorithms = TSPAlgorithms.ALLOWED;
            LOGGER.warn("No algorithm catalog specified. No garanty that requested Algorithms are apropriate.");
        } else {
            validAlgorithms = this.generateValidAlgorithmsList(genTime, this.algoCat);
            if (validAlgorithms == null) {
                LOGGER.error("No valid algorithms provided for country {} at date {}. Can't check if hash algorithm is appropriate", (Object)this.algoCat, (Object)genTime);
                return this.createFailureResponse(policy, 2, 0x40000000, "No valid algorithms provided for " + this.algoCat + "at date " + genTime);
            }
            try {
                if (!this.checkSignatureAlgo(this.algoCat, signatureAlgorithm, timestampServerKeyStore, alias, policy)) {
                    LOGGER.error("Unsupported signature algorithm: {}", (Object)signatureAlgorithm);
                    return this.createFailureResponse(policy, 2, 128, "unsupported signature algorithm.");
                }
            }
            catch (UnsupportedCatalogNameException | IllegalArgumentException e) {
                LOGGER.error("An error occuerd whilest validating signature algorithm.", e);
                return this.createFailureResponse(policy, 2, 0x40000000, "Failed to validate signature algorithm.");
            }
        }
        TimeStampTokenGenerator timestampTokenGenerator = null;
        try {
            timestampTokenGenerator = this.createGenerator(timestampServerKeyStore, alias, signatureAlgorithm, digestAlgorithm, policy);
        }
        catch (IllegalArgumentException | CertificateEncodingException | OperatorCreationException e1) {
            LOGGER.error("Failed to create token generator: ", e1);
            return this.createFailureResponse(policy, 2, 0x40000000, "Failed to create token generator.");
        }
        if (timestampTokenGenerator == null) {
            LOGGER.error("Failed to create token generator.");
            return this.createFailureResponse(policy, 2, 0x40000000, "Failed to create token generator.");
        }
        timestampTokenGenerator.setAccuracySeconds(accuracy);
        TimeStampResponseGenerator responseGenerator = new TimeStampResponseGenerator(timestampTokenGenerator, validAlgorithms, policy);
        if (serialNumber == null) {
            serialNumber = this.genUniqueSerialNumber(requestBytes);
        }
        TimeStampResponse timestamp = responseGenerator.generate(timeStampRequest, serialNumber, genTime);
        try {
            if (timestamp.getTimeStampToken() != null && !this.checkTS(timestamp, timeStampRequest)) {
                LOGGER.error("Generated timestamp is not valid.");
                return this.createFailureResponse(policy, 2, 0x40000000, "Generated timestamp is not valid.");
            }
        }
        catch (TSPException e) {
            LOGGER.error("Failed to verify timestamp.", (Throwable)e);
            return this.createFailureResponse(policy, 2, 0x40000000, "Could not verify timestamp.");
        }
        return timestamp;
    }

    private TimeStampResponse createFailureResponse(Set<ASN1ObjectIdentifier> policy, int status, int failInfo, String statusString) throws TSPException {
        TimeStampResponseGenerator failedResponseGenerator = new TimeStampResponseGenerator(null, null, policy);
        return failedResponseGenerator.generateFailResponse(status, failInfo, statusString);
    }

    public boolean checkSignatureAlgo(String algoCat, SignatureAlgorithm signatureAlgorithm, KeyStore timestampServerKeyStore, String alias, Set<ASN1ObjectIdentifier> policy) throws UnsupportedCatalogNameException {
        Date genTime = new Date();
        PublicKey issuerKey = null;
        issuerKey = (PublicKey)this.getKey(timestampServerKeyStore, alias, false);
        if (issuerKey instanceof RSAPublicKey) {
            LOGGER.info("public key - strength: {} bits", (Object)((RSAPublicKey)issuerKey).getModulus().bitLength());
        }
        return this.checkServiceState(this.algoCats, algoCat).isValid(algoCat, signatureAlgorithm, issuerKey, Usage.SIGN_TIMESTAMP, genTime);
    }

    private Set<ASN1ObjectIdentifier> generateValidAlgorithmsList(Date genTime, String algorithmCatalog) {
        HashSet<ASN1ObjectIdentifier> validAlgorithms = new HashSet<ASN1ObjectIdentifier>();
        Set algorithms = this.checkServiceState(this.algoCats, algorithmCatalog).getAlgorithmValidities(algorithmCatalog).keySet();
        for (String algo : algorithms) {
            DigestAlgorithm digAlgo = AlgorithmService.getDigestForJCAName((String)algo);
            if (digAlgo == null) continue;
            try {
                if (!this.algoCats.isValid(algorithmCatalog, digAlgo, Usage.SIGN_TIMESTAMP, genTime)) continue;
                validAlgorithms.add(new ASN1ObjectIdentifier(digAlgo.getOID()));
            }
            catch (UnsupportedCatalogNameException e) {
                LOGGER.error("Failed to build list of supported algorithms.", (Throwable)e);
                return null;
            }
        }
        return validAlgorithms;
    }

    public boolean checkTS(TimeStampResponse timestampResponse, TimeStampRequest timestampRequest) {
        return TimestampResponseValidator.checkTS(timestampResponse, timestampRequest);
    }

    boolean validateExtendedKeyUsage(X509CertificateHolder x509CertificateHolder, ExtendedKeyUsage extendedKeyUsage) {
        Extensions exts = x509CertificateHolder.getExtensions();
        if (exts == null || exts.getExtension(Extension.extendedKeyUsage) == null) {
            LOGGER.info("Validation of extended key usage failed because the certificate does not contain an extended key usage.");
            return false;
        }
        Extension ext = exts.getExtension(Extension.extendedKeyUsage);
        ExtendedKeyUsage ku = ExtendedKeyUsage.getInstance((Object)ext.getParsedValue());
        if (!extendedKeyUsage.equals((Object)ku)) {
            LOGGER.info("Wrong key usage: {}  expected was: {}", (Object)ku, (Object)extendedKeyUsage);
            return false;
        }
        return true;
    }

    public AlgorithmCatalog getAlgoCat(String algorithmCatalog) {
        return (AlgorithmCatalog)this.checkServiceState(this.algoCats, algorithmCatalog).getCatalogs().get(algorithmCatalog);
    }

    private AlgorithmCatalogs checkServiceState(AlgorithmCatalogs algoCatalogs, String algoCat) {
        if (algoCatalogs == null) {
            throw new IllegalStateException("algorithm catalogs not configured yet");
        }
        Map catalogs = algoCatalogs.getCatalogs();
        if (catalogs == null) {
            throw new IllegalStateException("empty algorithm catalogs configured, no catalogs available at all");
        }
        if (algoCat != null && catalogs.get(algoCat) == null) {
            throw new IllegalStateException("algorithm catalog  '" + algoCat + "' not available");
        }
        return algoCatalogs;
    }

    private BigInteger genUniqueSerialNumber(byte[] inSeed) {
        String random = "" + new RFCTimestampRequestGenerator().getRandomNonce(inSeed).mod(new BigInteger(Integer.toString(1000000000)));
        return new BigInteger(random + new MicroDate().get());
    }

    private static class MicroDate {
        private final long millis = System.currentTimeMillis();
        private final long micros = System.nanoTime();
        private final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.GERMANY);

        private MicroDate() {
        }

        public String get() {
            long microSeconds = (System.nanoTime() - this.micros) / 1000L;
            long date = this.millis + microSeconds / 1000L;
            return this.format.format(date) + String.format("%03d", microSeconds % 1000L);
        }
    }
}

