/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsp;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512tDigest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;

public class RFCTimestampRequestGenerator {
    public TimeStampRequest genReq(ASN1ObjectIdentifier digestAlgorithm, byte[] digestValue, boolean certReq, ASN1ObjectIdentifier reqPolicy, BigInteger nonce) {
        TimeStampRequestGenerator requestGenerator = new TimeStampRequestGenerator();
        requestGenerator.setCertReq(certReq);
        requestGenerator.setReqPolicy(reqPolicy);
        return requestGenerator.generate(digestAlgorithm, digestValue, nonce);
    }

    public TimeStampRequest genReq(ASN1ObjectIdentifier digestAlgorithm, byte[] digestValue, boolean certReq, ASN1ObjectIdentifier reqPolicy) {
        BigInteger nonce = this.getRandomNonce(digestValue);
        return this.genReq(digestAlgorithm, digestValue, certReq, reqPolicy, nonce);
    }

    public byte[] genDigestValue(byte[] toDigest, String algo) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest = MessageDigest.getInstance(algo, "BC");
        return messageDigest.digest(toDigest);
    }

    public BigInteger getRandomNonce(byte[] seed) {
        SHA512tDigest digest = new SHA512tDigest(128);
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator((Digest)digest);
        digestRandomGenerator.addSeedMaterial(seed);
        byte[] bytes = new byte[128];
        digestRandomGenerator.nextBytes(bytes);
        return new BigInteger(bytes);
    }
}

