/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsp;

import de.governikus.csl.tsp.TSPResponseException;
import java.util.stream.IntStream;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSLPKIFailureInfo
extends PKIFailureInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSLPKIFailureInfo.class);
    public static final int duplicateCertReq = 0x20000000;
    public static final int badTime = 16;
    public static final int badCertId = 8;
    public static final int wrongAuthority = 2;
    public static final int incorrectData = 1;
    public static final int missingTimeStamp = 32768;
    public static final int badPOP = 16384;
    public static final int certRevoked = 8192;
    public static final int certConfirmed = 4096;
    public static final int wrongIntegrity = 2048;
    public static final int badRecipientNonce = 1024;
    public static final int badSenderNonce = 0x200000;
    public static final int badCertTemplate = 0x100000;
    public static final int signerNotTrusted = 524288;
    public static final int transactionIdInUse = 262144;
    public static final int unsupportedVersion = 131072;
    public static final int notAuthorized = 65536;
    public static final int systemUnavail = Integer.MIN_VALUE;
    private static final int[] RFC3161_SUPPORTED_INFO_CODE = new int[]{128, 32, 4, 512, 256, 0x800000, 0x400000, 0x40000000};

    public CSLPKIFailureInfo(int info) throws TSPResponseException {
        super(info);
        if (!IntStream.of(RFC3161_SUPPORTED_INFO_CODE).anyMatch(x -> x == info)) {
            LOGGER.error("Unsupported FailureInfo: {}", (Object)info);
            throw new TSPResponseException(2, new CSLPKIFailureInfo(0x40000000), "Received PKIFailureInfo not conform with RFC 3161: " + info);
        }
    }

    public CSLPKIFailureInfo(PKIFailureInfo info) throws TSPResponseException {
        this(info.intValue());
    }

    public String toString() {
        switch (super.intValue()) {
            case 128: {
                return "unrecognized or unsupported Algorithm Identifier";
            }
            case 32: {
                return "transaction not permitted or supported";
            }
            case 4: {
                return "the data submitted has the wrong format";
            }
            case 512: {
                return "the TSA's time source is not available";
            }
            case 256: {
                return "the requested TSA policy is not supported by the TSA";
            }
            case 0x800000: {
                return "the requested extension is not supported by the TSA";
            }
            case 0x400000: {
                return "the additional information requested could not be understood or is not available";
            }
            case 0x40000000: {
                return "the request cannot be handled due to system failure";
            }
        }
        return "no failure info available";
    }
}

