/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityCheck
extends AbstractValidationCriterion<BaseCertificateSignature<?>, CertificateValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidityCheck.class);

    @Override
    public void verify(BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        Object c;
        LOGGER.debug("Verify, that a signed certificate was valid on signing date.");
        TypedDate bestSigningTime = context.getBestSigningTime();
        Date dateToCheck = bestSigningTime.getDate();
        ValidationResult signal = null;
        signal = dateToCheck == null ? SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE) : ((c = signature.getCert()) == null ? SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND) : (!this.isInValidityRange((X509CertificateBaseFacade<?>)c, dateToCheck) ? (this.isContentTstGenerationAfterExpiration(context, (X509CertificateBaseFacade<?>)c) ? SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.EXPIRED) : (this.isNotRevoked(result) ? (this.isSignatureTstGenerationBeforeValidity((de.governikus.csl.uom.TypedDate)bestSigningTime, (X509CertificateBaseFacade<?>)c) ? SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.NOT_YET_VALID) : SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.OUT_OF_BOUNDS_NOT_REVOKED)) : SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.OUT_OF_BOUNDS_NO_POE))) : SVPFactory.createResultOk()));
        result.setValidityCheck(signal);
    }

    private boolean isSignatureTstGenerationBeforeValidity(de.governikus.csl.uom.TypedDate bestSigningTime, X509CertificateBaseFacade<?> certificate) {
        Date dateToCheck = bestSigningTime.getDate();
        boolean sigTstGenerationBeforeValidity = false;
        switch (bestSigningTime.getType()) {
            case QTST: 
            case TSA: 
            case TSS_ADES_QC_AND_QES: 
            case TSS_QC: {
                sigTstGenerationBeforeValidity = dateToCheck.before(certificate.getNotBefore());
                break;
            }
        }
        return sigTstGenerationBeforeValidity;
    }

    private boolean isContentTstGenerationAfterExpiration(SignatureValidationContext context, X509CertificateBaseFacade<?> c) {
        List<TimestampValidationResult> prefetchedContentTimestampValidationResults = context.getPrefetchedContentTimestampValidationResults();
        TimestampValidationResult mostRecentContentTimestampValidationResult = this.getMostRecentContentTimestampValidationResult(prefetchedContentTimestampValidationResults);
        if (mostRecentContentTimestampValidationResult != null) {
            Date generationTime = mostRecentContentTimestampValidationResult.getGenerationTime();
            CumulatedValidationResult overallResult = mostRecentContentTimestampValidationResult.getOverallResult(true);
            if (generationTime != null && MajorTotalResult.TOTAL_PASSED.equals((Object)overallResult.getMajor())) {
                Date notAfter = c.getNotAfter();
                return notAfter != null && generationTime.after(notAfter);
            }
        }
        return false;
    }

    private TimestampValidationResult getMostRecentContentTimestampValidationResult(List<TimestampValidationResult> prefetchedContentTimestampValidationResults) {
        TimestampValidationResult mostRecent = null;
        if (prefetchedContentTimestampValidationResults != null) {
            mostRecent = prefetchedContentTimestampValidationResults.stream().max((x, y) -> x.getGenerationTime().compareTo(y.getGenerationTime())).orElse(null);
        }
        return mostRecent;
    }

    private boolean isInValidityRange(X509CertificateBaseFacade<?> c, Date dateToCheck) {
        Date from = c.getNotBefore();
        Date to = c.getNotAfter();
        return from != null && dateToCheck.compareTo(from) >= 0 && to != null && dateToCheck.compareTo(to) <= 0;
    }

    private boolean isNotRevoked(CertificateValidationResult result) {
        return result.getRevocationValueValidationResult() != null && RevocationStatus.OK.equals((Object)result.getRevocationValueValidationResult().getStatus());
    }
}

