/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;

public class TLValidityCheck
extends AbstractValidationCriterion<X509Data, PublicKeyCertificateValidationResult, SignatureValidationContext> {
    @Override
    public void verify(X509Data signature, PublicKeyCertificateValidationResult result, SignatureValidationContext context) {
        Date nextUpdate;
        ExtendedTLInformation tslInformation = signature.getTslInformation();
        TLInfo tlInfo = tslInformation.getTslInfo();
        TLInfo tlExtensionInfo = tslInformation.getTslExtensionInfo();
        Date now = new Date();
        if (tlInfo != null && (nextUpdate = tlInfo.getNextUpdate()).before(now)) {
            result.setTlValidityCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tl_expired"}));
            return;
        }
        if (tlExtensionInfo != null && (nextUpdate = tlExtensionInfo.getNextUpdate()).before(now)) {
            result.setTlValidityCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tl_extension_expired"}));
            return;
        }
        result.setTlValidityCheck(SVPFactory.createResultOk());
    }

    @Override
    public boolean preconditionsFulfilled(X509Data signature, PublicKeyCertificateValidationResult result) {
        return signature.getTslInformation() != null;
    }
}

