/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.KeyUsage;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.utils.TrustStoreResponse;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.InternationalizedString;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.TSPInfo;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationTrustCheck
extends AbstractValidationCriterion<BaseCertificateSignature<?>, CertificateValidationResult, CertificateValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationTrustCheck.class);
    private static final String OLD_NOT_MONITORED_URI = "http://www.governikus.de/validation-constraints/service_status_not_monitored";

    @Override
    public void verify(BaseCertificateSignature<?> signature, CertificateValidationResult result, CertificateValidationContext context) {
        PublicKeyCertificateValidationResult revocationValueSignersChainElementInTl;
        LOGGER.debug("Veryfying revocation trust");
        X509Data anchor = context.getRevocationTrustCheckAnchor();
        PublicKeyCertificateValidationResult revocationValueSigner = result.getRevocationValueValidationResult().getSigningCertificateValidationResult();
        Date claimedSigningTimeRevocationValue = result.getRevocationValueValidationResult().getClaimedSigningTime();
        TrustStore trustStore = context.getTrustStore();
        for (revocationValueSignersChainElementInTl = revocationValueSigner; revocationValueSignersChainElementInTl != null && revocationValueSignersChainElementInTl.getServiceInfo() == null; revocationValueSignersChainElementInTl = revocationValueSignersChainElementInTl.getSigningCertificateValidationResult()) {
        }
        this.checkRevocationTrust(result, anchor, revocationValueSignersChainElementInTl, claimedSigningTimeRevocationValue, trustStore);
    }

    private void checkRevocationTrust(CertificateValidationResult result, X509Data anchor, PublicKeyCertificateValidationResult revocationValueSignersChainElementInTl, Date claimedSigningTimeRevocationValue, TrustStore trustStore) {
        ServiceInformation serviceInformation;
        if (revocationValueSignersChainElementInTl == null || anchor == null) {
            result.setRevocationTrustCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, null, (String[])new String[]{"revocation_values_indeterminate_trust_level"}));
            return;
        }
        boolean isCrlAndHasValidCrlCert = this.isOCSP(result.getRevocationValueValidationResult()) || !this.isOCSP(result.getRevocationValueValidationResult()) && this.hasCertCrlSigningKey(revocationValueSignersChainElementInTl);
        boolean sameProvider = this.isSameProvider(anchor, revocationValueSignersChainElementInTl);
        boolean takenOverBy = this.isTakenOverBy(anchor, revocationValueSignersChainElementInTl, claimedSigningTimeRevocationValue, trustStore);
        TrustStoreResponse tsResp = trustStore.getCertificateInformation((X509CertificateBaseFacade)revocationValueSignersChainElementInTl.getCert(), claimedSigningTimeRevocationValue);
        boolean isOCSPSignerGrantedAtOCSPIssuingTime = false;
        if (tsResp != null && (serviceInformation = tsResp.getServiceInformation()) != null) {
            ServiceType serviceType = serviceInformation.getServiceTypeIdentifier();
            ServiceStatus serviceStatus = serviceInformation.getServiceStatus();
            isOCSPSignerGrantedAtOCSPIssuingTime = serviceType == ServiceType.NATIONAL_ROOT_CA_QC ? this.isStatusAllowedForNationalRoot(serviceStatus) : this.isStatusAllowed(serviceStatus);
        }
        if ((sameProvider || takenOverBy) && isOCSPSignerGrantedAtOCSPIssuingTime && isCrlAndHasValidCrlCert) {
            result.setRevocationTrustCheckResult(SVPFactory.createResultOk());
        } else {
            result.setRevocationTrustCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, null, (String[])new String[]{"revocation_values_insufficient_trust_level"}));
        }
    }

    private boolean isOCSP(RevocationValueValidationResult revocationValueValidationResult) {
        return revocationValueValidationResult != null && revocationValueValidationResult.getOcsp() != null && revocationValueValidationResult.getCrl() == null;
    }

    private boolean hasCertCrlSigningKey(PublicKeyCertificateValidationResult revocationResult) {
        if (revocationResult == null || revocationResult.getCert() == null) {
            return false;
        }
        X509CertificateImpl x509Certificate = revocationResult.getCert();
        return x509Certificate.isUsableFor(KeyUsage.CRL_SIGN);
    }

    private boolean isStatusAllowedForNationalRoot(ServiceStatus serviceStatus) {
        return serviceStatus == ServiceStatus.UNDER_SUPERVISION || serviceStatus == ServiceStatus.SUPERVISION_IN_CESSATION || serviceStatus == ServiceStatus.ACCREDITED || serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL || serviceStatus == ServiceStatus.SET_BY_NATIONAL_LAW;
    }

    private boolean isStatusAllowed(ServiceStatus serviceStatus) {
        return serviceStatus == ServiceStatus.UNDER_SUPERVISION || serviceStatus == ServiceStatus.SUPERVISION_IN_CESSATION || serviceStatus == ServiceStatus.ACCREDITED || serviceStatus == ServiceStatus.GRANTED || serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL || serviceStatus == ServiceStatus.NOT_MONITORED || serviceStatus != null && OLD_NOT_MONITORED_URI.equals(serviceStatus.getValue());
    }

    private boolean isSameProvider(X509Data s, PublicKeyCertificateValidationResult r) {
        if (s == null || r == null) {
            return false;
        }
        ServiceInformation serviceInformation1 = s.getServiceInformation();
        if (serviceInformation1 == null) {
            return false;
        }
        TSPInfo tspInformation1 = serviceInformation1.getTspInformation();
        TSPInfo tspInformation2 = r.getTrustServiceProviderInformation();
        return tspInformation1 != null && tspInformation2 != null && (tspInformation1 == tspInformation2 || this.containsAny(tspInformation1.getTradeNames(), tspInformation2.getTradeNames()));
    }

    private boolean containsAny(List<InternationalizedString> tradeNames1, List<InternationalizedString> tradeNames2) {
        if (tradeNames1 == null || tradeNames2 == null) {
            return false;
        }
        for (InternationalizedString tn1 : tradeNames1) {
            for (InternationalizedString tn2 : tradeNames2) {
                if (!tn1.equals((Object)tn2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTakenOverBy(X509Data anchor, PublicKeyCertificateValidationResult r, Date claimedSigningTimeRevocationValue, TrustStore trustStore) {
        boolean isTakenOverBy = false;
        TrustStoreResponse trustStoreResponse = this.checkTl(trustStore, claimedSigningTimeRevocationValue, anchor);
        if (trustStoreResponse != null && r != null && trustStoreResponse.getServiceInformation() != null && r.getTrustServiceProviderInformation() != null && trustStoreResponse.getServiceInformation().getTakenOverBy() != null) {
            for (InternationalizedString tspName : trustStoreResponse.getServiceInformation().getTakenOverBy().getTspName()) {
                boolean found = false;
                for (InternationalizedString ad : r.getTrustServiceProviderInformation().getNames()) {
                    if (!tspName.getValue().equals(ad.getValue())) continue;
                    found = true;
                    isTakenOverBy = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return isTakenOverBy;
    }

    @Override
    public boolean preconditionsFulfilled(BaseCertificateSignature<?> signature, CertificateValidationResult result) {
        return result.getRevocationValueValidationResult() != null && result.getRevocationValueValidationResult().getSigningCertificateValidationResult() != null && result.getRevocationStatusCheck() != null;
    }

    private TrustStoreResponse checkTl(TrustStore trustStore, Date referenceDate, X509Data cert) {
        return trustStore.getCertificateInformation(cert.getCert(), referenceDate);
    }

    @Override
    public boolean isApplicable(BaseCertificateSignature<?> signature, CertificateValidationResult result, CertificateValidationContext context) {
        Boolean revocationValueTrustCheckRequired;
        ValidationPolicyType policy = context.getPolicy();
        if (policy != null && (revocationValueTrustCheckRequired = policy.isRevocationValueTrustCheckRequired()) != null) {
            return revocationValueTrustCheckRequired;
        }
        return true;
    }
}

