/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.FailureInterpretation;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.CRLReason;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.AbstractRevocationValuePlugin;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.revocation.criteria.RevocationValueTrustCheckCertProcessor;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.chain.CertChainValidationStep;
import de.governikus.csl.validation.x509.chain.ValidationStepChecker;
import de.governikus.tslextension.ValMethodOCSP;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationStatusChecker
extends RecursiveValidationCriterion<BaseCertificateSignature<?>, CertificateValidationResult, RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationStatusChecker.class);

    @Override
    public void verify(BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        Object userCert = signature.getCert();
        if (context.getOcspStack().contains(userCert)) {
            LOGGER.debug("Recursive ocsp-call for certificate");
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"revocation_values_already_validated"}));
            return;
        }
        if (signature.isTrustedAnchor()) {
            LOGGER.debug("Certificate is trusted anchor, requestion of ocsp-values is not nessecary");
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"cert_as_trusted_anchor_by_tsl"}));
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requesting OCSP-Values for {}", (Object)userCert.getSerialNumber());
        }
        try {
            ValidationPolicyType policy = context.getPolicy();
            boolean onlyOCSP = policy.isOnlyOCSPAllowed();
            RevocationValue rv = context.getRevocationValueRequester().getRevocationValue(signature, context, onlyOCSP);
            if (rv == null || rv.hasValidationMessages()) {
                ValidationResult validationResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{onlyOCSP ? "revocation_values_not_found_only_ocsp" : "revocation_values_not_found"});
                result.setRevocationStatusCheck(validationResult);
                if (rv != null && rv.hasValidationMessages()) {
                    validationResult.getMessages().addAll(rv.getValidationMessageCodes());
                }
                LOGGER.warn("No revocation found");
                return;
            }
            rv.setCertificateToCheck(userCert);
            context.setLastOCSPURL(rv.getUrl());
            context.getOcspStack().push((CertificateBase)userCert);
            this.verifyResponse(rv, signature, result, context);
            context.getOcspStack().pop();
        }
        catch (Exception e) {
            LOGGER.warn("Error getting revocation value.", (Throwable)e);
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished Requesting OCSP-Values for {} - #{}", (Object)userCert.getSubjectX500Principal(), (Object)userCert.getSerialNumber());
        }
    }

    private void verifyResponse(RevocationValue rv, BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        ValidationResult statusResult = null;
        int responseStatus = rv.getResponseStatus();
        switch (responseStatus) {
            case 0: {
                statusResult = this.processSuccessfulResponse(rv, signature, result, context);
                break;
            }
            case 2: {
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (String[])new String[]{"revocation_values_responder_error"});
                break;
            }
            case 1: {
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_bad_request"});
                break;
            }
            case 5: {
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_sig_required"});
                break;
            }
            case 3: {
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (String[])new String[]{"revocation_values_try_later"});
                break;
            }
            case 6: {
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_unauthorized"});
                break;
            }
            default: {
                LOGGER.warn("Unsupported OCSP response status: {}", (Object)responseStatus);
                statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_unsupported_status"});
            }
        }
        result.setRevocationStatusCheck(statusResult);
    }

    private ValidationResult processSuccessfulResponse(RevocationValue rv, BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        RevocationValueData wrapper;
        ValidationResult statusResult = null;
        ValidationPolicyType policy = context.getPolicy();
        Date revocationDate = null;
        switch (rv.getStatus()) {
            case OK: {
                Date issuanceDate = rv.getCreationDate();
                Date archiveCutoffDate = this.determineDateToCompare(signature, rv);
                statusResult = signature.process(new RevocationValueTrustCheckCertProcessor(revocationDate, archiveCutoffDate, issuanceDate));
                break;
            }
            case REVOKED: {
                CRLReason reason = rv.getReason();
                revocationDate = rv.getRevocationDate();
                TypedDate bestSigningTime = context.getBestSigningTime();
                Date dateToCompare = bestSigningTime.getDate();
                boolean revokedBeforeBST = revocationDate.before(dateToCompare);
                statusResult = revokedBeforeBST ? (this.isContentTstGenerationAfterRevocation(context, revocationDate) ? SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.REVOKED) : SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.REVOKED_NO_POE)) : SVPFactory.createResultOk();
                result.setRevocationDate(revocationDate);
                result.setRevocationReason(reason);
                break;
            }
            case UNKNOWN: {
                statusResult = this.createUnknownCertResult((ValidatePolicy)policy);
            }
        }
        AbstractRevocationValuePlugin plugin = null;
        String name = null;
        if (rv.getOcspValue() != null) {
            plugin = (AbstractRevocationValuePlugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_OCSP.getID());
            name = "OCSP-Signature";
        } else {
            plugin = (AbstractRevocationValuePlugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_CRL.getID());
            name = "CRL-Signature";
        }
        try {
            wrapper = plugin.parseDocument(rv, (CertStore)context.getCertStore());
            wrapper.setName(name);
            wrapper.setIssuanceTime(rv.getCreationDate());
            wrapper.setNextUpdate(rv.getNextUpdate());
            wrapper.setThisUpdate(rv.getThisUpdate());
        }
        catch (ValidatePluginException e) {
            LOGGER.error("Can't parse document.", (Throwable)((Object)e));
            statusResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE);
            return statusResult;
        }
        RevocationValueValidationContext revocationValueContext = (RevocationValueValidationContext)plugin.createContext(wrapper, context);
        revocationValueContext.setRevocationDate(revocationDate);
        revocationValueContext.setValidationDate(new Date());
        revocationValueContext.setCertificateToCheck(signature);
        revocationValueContext.setCertBestPOE(context.getBestSigningTime());
        revocationValueContext.setBestSigningTime(BestPOEDeterminator.getBestPOE((Signature)wrapper, null, context.getValidationDate(), (ValidatePolicy)policy));
        List poes = rv.getPoes();
        revocationValueContext.setBestAlgValidationTime(BestPOEDeterminator.getBestPOEForAlgorithmValidity(poes, context.getValidationDate(), (ValidatePolicy)policy));
        revocationValueContext.setCertificatePathReferences(null);
        RevocationValueValidationResult revocationValueValidationResult = this.recursiveCall(wrapper, plugin, revocationValueContext);
        revocationValueValidationResult.setInformationSource(rv.getSource());
        result.setRevocationValueValidationResult(revocationValueValidationResult);
        this.addMessageWhenRevokedAndExpired(statusResult, revocationValueContext, rv);
        return statusResult;
    }

    private boolean isRevokedStatus(ValidationResult statusResult, RevocationValue rv) {
        return statusResult != null && (!MinorResult.REVOKED.equals((Object)statusResult.getMinor()) || !MinorResult.REVOKED_NO_POE.equals((Object)statusResult.getMinor())) && RevocationStatus.REVOKED.equals((Object)rv.getStatus());
    }

    private void addMessageWhenRevokedAndExpired(ValidationResult statusResult, RevocationValueValidationContext context, RevocationValue revocationValue) {
        BaseCertificateSignature<?> certificateToCheck;
        if (this.isRevokedStatus(statusResult, revocationValue) && (certificateToCheck = context.getCertificateToCheck()) != null) {
            Date certNotAfter = certificateToCheck.getCert().getNotAfter();
            Date revocationCreationDate = revocationValue.getCreationDate();
            boolean isCertExpiredAtRevocationCreation = revocationCreationDate.after(certNotAfter);
            if (isCertExpiredAtRevocationCreation) {
                TypedDate certBestPOE = context.getCertBestPOE();
                boolean isExpiredAtBestPOE = certBestPOE.getDate().after(certNotAfter);
                Date revocationDate = revocationValue.getRevocationDate();
                boolean isRevokedAtBestPOE = certBestPOE.getDate().after(revocationDate);
                if (!isExpiredAtBestPOE && !isRevokedAtBestPOE) {
                    statusResult.getMessages().add(SVPFactory.createMessageCode((String)"revocation_value_trust_valid_because_poe_before_revocation"));
                } else {
                    statusResult.getMessages().add(SVPFactory.createMessageCode((String)"revocation_value_trust_valid_because_revoked"));
                }
            }
        }
    }

    private ValidationResult createUnknownCertResult(ValidatePolicy policy) {
        FailureInterpretation revokedCertificateInterpretation = policy.getRevokedCertificateInterpretation();
        switch (revokedCertificateInterpretation) {
            case INDETERMINATE_RESULT: {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_status_unknown"});
            }
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_status_unknown"});
    }

    private boolean isContentTstGenerationAfterRevocation(SignatureValidationContext context, Date revocationDate) {
        List<TimestampValidationResult> prefetchedContentTimestampValidationResults = context.getPrefetchedContentTimestampValidationResults();
        TimestampValidationResult mostRecentContentTimestampValidationResult = this.getMostRecentContentTimestampValidationResult(prefetchedContentTimestampValidationResults);
        if (mostRecentContentTimestampValidationResult != null) {
            Date generationTime = mostRecentContentTimestampValidationResult.getGenerationTime();
            CumulatedValidationResult overallResult = mostRecentContentTimestampValidationResult.getOverallResult(true);
            if (generationTime != null && MajorTotalResult.TOTAL_PASSED.equals((Object)overallResult.getMajor())) {
                return revocationDate != null && generationTime.after(revocationDate);
            }
        }
        return false;
    }

    private TimestampValidationResult getMostRecentContentTimestampValidationResult(List<TimestampValidationResult> prefetchedContentTimestampValidationResults) {
        TimestampValidationResult mostRecent = null;
        if (prefetchedContentTimestampValidationResults != null) {
            mostRecent = prefetchedContentTimestampValidationResults.stream().max((x, y) -> x.getGenerationTime().compareTo(y.getGenerationTime())).orElse(null);
        }
        return mostRecent;
    }

    @Override
    public boolean isApplicable(BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        boolean isApplicable;
        CertChainValidationStep certChainValidationDepth = context.getCertChainValidationDepth();
        ValidationStepChecker checker = context.getRevocationValueValidationDepthChecker();
        ValidationPolicyType policy = context.getPolicy();
        Boolean selfSignedCertificateRevocationCheckRequired = policy.isSelfSignedCertificateRevocationCheckRequired();
        boolean bl = isApplicable = checker.check(certChainValidationDepth) && (!signature.isSelfSigned() || selfSignedCertificateRevocationCheckRequired != false);
        if (!isApplicable) {
            if (this.isSelfSignedEE(signature)) {
                result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_status_not_available_self_signed_ee"}));
            } else {
                result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            }
            return false;
        }
        if (this.isOcspNoCheckInTlExtension(signature)) {
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (String[])new String[]{"revocation_values_ocsp_no_check_tl"}));
            return false;
        }
        if (this.isOCSPSigningCertAndOCSPNoCheckAvailable((X509CertificateBaseFacade<?>)signature.getCert())) {
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (String[])new String[]{"revocation_values_ocsp_no_check"}));
            return false;
        }
        if (this.isShortTermCertificate((X509CertificateBaseFacade<?>)signature.getCert(), (ValidatePolicy)policy)) {
            result.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, null, (String[])new String[]{"revocation_values_signer_certificate_no_check"}));
            return false;
        }
        return true;
    }

    private boolean isShortTermCertificate(X509CertificateBaseFacade<?> cert, ValidatePolicy policy) {
        byte[] validityAsuredShortTermExt;
        boolean result = false;
        if (cert != null && (validityAsuredShortTermExt = cert.getExtensionValue("0.4.0.194121.2.1")) != null && !policy.isRevocationRequestRequiredForShortTermCertificate().booleanValue()) {
            result = true;
        }
        return result;
    }

    private boolean isSelfSignedEE(BaseCertificateSignature<?> signature) {
        CertificateQualificationInformation qualityInformation = signature.getQualityInformation();
        return qualityInformation != null && signature.isSelfSigned() && CertificateQualification.ADS.equals((Object)qualityInformation.getCertificateQualification());
    }

    private boolean isOcspNoCheckInTlExtension(BaseCertificateSignature<?> signature) {
        ServiceInformation serviceInformation = signature.getServiceInformation();
        if (serviceInformation == null) {
            return false;
        }
        ValMethodOCSP valMethodOCSP = serviceInformation.getValMethodOCSP();
        if (valMethodOCSP == null) {
            return false;
        }
        return valMethodOCSP.isOcspNoCheck();
    }

    private boolean isOCSPSigningCertAndOCSPNoCheckAvailable(X509CertificateBaseFacade<?> cert) {
        byte[] ocspNoCheck;
        if (cert != null && (ocspNoCheck = cert.getExtensionValue("1.3.6.1.5.5.7.48.1.5")) != null && cert instanceof X509CertificateImpl) {
            X509CertificateImpl x509 = (X509CertificateImpl)cert;
            List extendedKeyUsage = null;
            try {
                extendedKeyUsage = x509.getExtendedKeyUsage();
            }
            catch (CertificateParsingException e) {
                LogHelper.logException((String)"Can't get extended key usage from certificate", (Logger)LOGGER, (Throwable)e);
            }
            if (extendedKeyUsage != null) {
                for (String ku : extendedKeyUsage) {
                    if (!"1.3.6.1.5.5.7.3.9".equals(ku)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Date determineDateToCompare(BaseCertificateSignature<?> certificateToCheck, RevocationValue rv) {
        Date dateToCompare = null;
        dateToCompare = rv.getOcspValue() != null ? this.getArchiveCutOff(certificateToCheck, rv) : this.parseExpiredCertsOnCRL(rv.getCrlValue());
        return dateToCompare;
    }

    private Date getArchiveCutOff(BaseCertificateSignature<?> certificateToCheck, RevocationValue revocationValue) {
        Date expiredCertsRevocationInfo = Optional.ofNullable(certificateToCheck.getIssuerServiceInformation()).map(ServiceInformation::getExpiredCertsRevocationInfo).orElse(null);
        return Optional.ofNullable(certificateToCheck.getIssuerServiceInformation()).map(ServiceInformation::getValMethodOCSP).map(ValMethodOCSP::getArchiveCutOff).orElse(Optional.ofNullable(revocationValue.getArchiveCutoffDate()).orElse(expiredCertsRevocationInfo));
    }

    private Date parseExpiredCertsOnCRL(X509CRL crlValue) {
        byte[] expiredCertsOnCRLExtension;
        if (crlValue != null && (expiredCertsOnCRLExtension = crlValue.getExtensionValue("2.5.29.60")) != null) {
            try {
                ASN1OctetString instance = ASN1OctetString.getInstance((Object)expiredCertsOnCRLExtension);
                expiredCertsOnCRLExtension = instance.getOctets();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Can't parse ExpiredCertsOnCRL-Extension: {}", (Object)e.getMessage());
                return null;
            }
            try {
                ASN1GeneralizedTime idp = ASN1GeneralizedTime.getInstance((Object)expiredCertsOnCRLExtension);
                return idp.getDate();
            }
            catch (Exception e) {
                LOGGER.debug("Can't parse ExpiredCertsOnCRL-Extension: {}", (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

