/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.X509Data;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionCheck
extends AbstractValidationCriterion<X509Data, PublicKeyCertificateValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionCheck.class);

    @Override
    public void verify(X509Data signature, PublicKeyCertificateValidationResult result, SignatureValidationContext context) {
        LOGGER.debug("Verifying extensions");
        X509CertificateImpl cert = (X509CertificateImpl)signature.getCert();
        X509Certificate wrappedCertificate = (X509Certificate)cert.getWrappedCertificate();
        if (!X509Certificate.class.isInstance(wrappedCertificate)) {
            return;
        }
        X509Certificate x509 = wrappedCertificate;
        Set<String> extensions = x509.getCriticalExtensionOIDs();
        if (extensions != null) {
            for (String oid : extensions) {
                if ("2.5.29.19".equals(oid)) {
                    byte[] extensionValue = x509.getExtensionValue(oid);
                    if (this.checkBasicConstraint(x509, extensionValue, result, context)) continue;
                    return;
                }
                if ("1.3.36.8.3.1".equals(oid) || "1.3.6.1.5.5.7.1.3".equals(oid) || "2.5.29.37".equals(oid) || "2.5.29.15".equals(oid)) continue;
                LOGGER.debug("Unsupported extension type: {}", (Object)oid);
            }
        }
        this.setResult(result, SVPFactory.createResultOk());
    }

    private boolean checkBasicConstraint(X509Certificate x509, byte[] extensionValue, PublicKeyCertificateValidationResult result, SignatureValidationContext context) {
        LOGGER.debug("Checking certificate basic constraint");
        ASN1OctetString octet = ASN1OctetString.getInstance((Object)extensionValue);
        BasicConstraints instance = BasicConstraints.getInstance((Object)ASN1Sequence.getInstance((Object)octet.getOctets()));
        boolean ca = instance.isCA();
        boolean[] keyUsage = x509.getKeyUsage();
        if (keyUsage == null) {
            return true;
        }
        boolean keyCertSign = keyUsage[5];
        if (ca) {
            int currentPosition;
            BigInteger pathLenConstraint = instance.getPathLenConstraint();
            if (pathLenConstraint != null && keyCertSign && (currentPosition = context.getCertChainValidationDepth().getCurrentPositionInCertChain()) > pathLenConstraint.intValue() + 2) {
                this.setErrorResult(result, "x509_basic_constraint_max_path_length_exceeded");
                return false;
            }
        } else if (keyCertSign) {
            this.setErrorResult(result, "x509_basic_constraint_no_ca_with_key_cert_sign");
            return false;
        }
        return true;
    }

    private void setErrorResult(PublicKeyCertificateValidationResult result, String msg) {
        this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{msg}));
    }

    private void setResult(PublicKeyCertificateValidationResult result, ValidationResult validationResult) {
        result.setExtensionCheck(validationResult);
    }
}

