/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.util.List;

public class CheckTrustStoreReliability
extends AbstractValidationCriterion<BaseCertificateSignature<?>, CertificateValidationResult, SignatureValidationContext> {
    @Override
    public void verify(BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        List trustStoreReliabilityConcerns = null;
        ExtendedTLInformation tslInformation = signature.getTslInformation();
        if (tslInformation != null) {
            trustStoreReliabilityConcerns = tslInformation.getReliabilityConcerns();
        }
        if (trustStoreReliabilityConcerns == null || trustStoreReliabilityConcerns.isEmpty()) {
            result.setTrustCenterReliability(SVPFactory.createResultOk());
        } else {
            result.setTrustCenterReliability(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (List)trustStoreReliabilityConcerns));
        }
    }
}

