/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.BaseCertificateSignature;

public class CheckChainEnd
extends AbstractValidationCriterion<BaseCertificateSignature<?>, CertificateValidationResult, SignatureValidationContext> {
    @Override
    public void verify(BaseCertificateSignature<?> signature, CertificateValidationResult result, SignatureValidationContext context) {
        if (!signature.isEndInChain()) {
            result.setCertChainCheck(SVPFactory.createResultOk());
            return;
        }
        QualityResult qualityResult = signature.getQualityResult();
        if (!(signature.isSelfSigned() || signature.isTrustedAnchor() || qualityResult != null && qualityResult.isQES())) {
            result.setCertChainCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_CERTIFICATE_CHAIN_FOUND));
        } else {
            result.setCertChainCheck(SVPFactory.createResultOk());
        }
    }
}

