/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.x509.X509Data;
import java.security.cert.Certificate;
import java.util.List;

public class CheckCertificateReferences
extends AbstractValidationCriterion<X509Data, PublicKeyCertificateValidationResult, SignatureValidationContext> {
    @Override
    public void verify(X509Data signature, PublicKeyCertificateValidationResult result, SignatureValidationContext context) {
        List<? extends CertificateReference> certificatePathReferences = context.getCertificatePathReferences();
        if (certificatePathReferences != null) {
            for (CertificateReference certificateReference : certificatePathReferences) {
                boolean refFound = false;
                X509Data precursorInCertChain = signature;
                do {
                    if (!certificateReference.isReferenced((Certificate)precursorInCertChain.getCert())) continue;
                    refFound = true;
                    break;
                } while ((precursorInCertChain = precursorInCertChain.getPrecursorInCertChain()) != null);
                if (refFound) continue;
                result.setCertChainReferencesConformance(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
                return;
            }
        }
        result.setCertChainReferencesConformance(SVPFactory.createResultOk());
    }

    @Override
    public boolean preconditionsFulfilled(X509Data signature, PublicKeyCertificateValidationResult result) {
        return signature.isSelfSigned() || signature.isTrustedAnchor();
    }
}

