/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.validation.x509.chain.CompareOperator;
import de.governikus.csl.validation.x509.chain.ValidationStepCheck;

public class ValueCheck
extends ValidationStepCheck {
    private CompareOperator operator;
    private int compareValue;

    public ValueCheck(CompareOperator operator, int compareValue) {
        this.operator = operator;
        this.compareValue = compareValue;
    }

    @Override
    protected boolean checkInternal(int[] map, int pos) {
        int value = map[pos];
        switch (this.operator) {
            case LESSTHAN: {
                return value < this.compareValue;
            }
            case EQUAL: {
                return value == this.compareValue;
            }
        }
        return value > this.compareValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.compareValue;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueCheck other = (ValueCheck)obj;
        if (this.compareValue != other.compareValue) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.operator.equals((Object)CompareOperator.LESSTHAN)) {
            sb.append("<");
        } else if (this.operator.equals((Object)CompareOperator.EQUAL)) {
            sb.append("=");
        } else {
            sb.append(">");
        }
        sb.append(this.compareValue);
        if (this.isForAllFollowingPositions()) {
            sb.append("+");
        }
        return sb.toString();
    }
}

