/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidityModel;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.ValidityModelReason;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Deque;
import java.util.Iterator;

public class ValidityModelDeterminator
implements CertificateProcessor<ValidityModelDeterminationResult> {
    private ServiceInformation serviceInformation;
    private ValidatePolicy policy;

    public ValidityModelDeterminator(BaseCertificateSignature<?> ee, Deque<X509Data> caCertificates, ValidatePolicy policy) {
        this.serviceInformation = ee.getServiceInformation();
        if (this.serviceInformation == null && caCertificates != null) {
            Iterator<X509Data> iter = caCertificates.descendingIterator();
            while (this.serviceInformation == null && iter.hasNext()) {
                X509Data cert = iter.next();
                this.serviceInformation = cert.getServiceInformation();
            }
        }
        this.policy = policy;
    }

    @Override
    public ValidityModelDeterminationResult process(AttributeCertificateSignature attributeCert) {
        return this.determinePathValidation(attributeCert);
    }

    @Override
    public ValidityModelDeterminationResult process(X509Data cert) {
        return this.determinePathValidation(cert);
    }

    private ValidityModelDeterminationResult determinePathValidation(BaseCertificateSignature<?> cert) {
        boolean useTrustCenterSettings = this.policy.isTrustCenterGuidelineIgnored() == false;
        ValidityModel validityModel = cert.getCert().getValidityModel();
        if (useTrustCenterSettings && validityModel != null) {
            if (validityModel.equals((Object)ValidityModel.CHAIN)) {
                validityModel = ValidityModel.ESCAPE_ROUTE;
            }
            ValidityModelDeterminationResult result = new ValidityModelDeterminationResult(this.mapValidityModel(validityModel), ValidityModelReason.CERTIFICATE_EXTENSION);
            result.setEnforceUsageOfClaimedSigningTime(validityModel != ValidityModel.SHELL);
            return result;
        }
        if (useTrustCenterSettings && this.serviceInformation != null && (validityModel = this.serviceInformation.getValidityModel()) != null) {
            ValidityModelDeterminationResult result = new ValidityModelDeterminationResult(this.mapValidityModel(validityModel), ValidityModelReason.TRUSTED_LIST_EXTENSION);
            result.setEnforceUsageOfClaimedSigningTime(validityModel != ValidityModel.SHELL);
            return result;
        }
        PathValidationMethod pathValidationMethod = this.policy.getPathValidationMethod();
        return new ValidityModelDeterminationResult(pathValidationMethod, ValidityModelReason.POLICY);
    }

    private PathValidationMethod mapValidityModel(ValidityModel validityModel) {
        switch (validityModel) {
            case CHAIN: {
                return PathValidationMethod.FORK;
            }
            case ESCAPE_ROUTE: {
                return PathValidationMethod.COMBINED;
            }
        }
        return PathValidationMethod.STRAIGHT;
    }
}

