/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.uom.validate.RevocationValueValidationDepth;
import de.governikus.csl.validation.x509.chain.CompareOperator;
import de.governikus.csl.validation.x509.chain.OkCheck;
import de.governikus.csl.validation.x509.chain.ValidationStepCheck;
import de.governikus.csl.validation.x509.chain.ValidationStepChecker;
import de.governikus.csl.validation.x509.chain.ValueCheck;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ValidationStepCheckerParser {
    private static final ValidationStepCheckerParser INSTANCE = new ValidationStepCheckerParser();
    private ValidationStepChecker maximalCertChainValidationStepChecker;
    private ValidationStepChecker minimalCertChainValidationStepChecker;
    private ValidationStepChecker normalCertChainValidationStepChecker;

    private ValidationStepCheckerParser() {
        ArrayList<ValidationStepCheck> checks = new ArrayList<ValidationStepCheck>();
        OkCheck check = new OkCheck();
        check.setForAllFollowingVersionParts(true);
        checks.add(check);
        this.maximalCertChainValidationStepChecker = new ValidationStepChecker(checks);
        checks = new ArrayList();
        check = new OkCheck();
        checks.add(check);
        this.minimalCertChainValidationStepChecker = new ValidationStepChecker(checks);
        checks = new ArrayList();
        checks.add(new OkCheck());
        checks.add(new OkCheck());
        this.normalCertChainValidationStepChecker = new ValidationStepChecker(checks);
    }

    public static ValidationStepCheckerParser getInstance() {
        return INSTANCE;
    }

    public ValidationStepChecker getVersionChecker(RevocationValueValidationDepth depth) throws ParseException {
        switch (depth) {
            case MAXIMAL: {
                return this.maximalCertChainValidationStepChecker;
            }
            case MINIMAL: {
                return this.minimalCertChainValidationStepChecker;
            }
            case NORMAL: {
                return this.normalCertChainValidationStepChecker;
            }
        }
        return null;
    }

    public ValidationStepChecker getVersionCheckerFromString(String pattern) throws ParseException, IllegalArgumentException {
        if (pattern == null) {
            throw new IllegalArgumentException("The given pattern is null!");
        }
        CharIterator iterator = new CharIterator(pattern);
        ArrayList<ValidationStepCheck> checks = new ArrayList<ValidationStepCheck>();
        ValidationStepCheckerParser.parsePattern(iterator, checks);
        if (checks.isEmpty()) {
            throw new ParseException("Pattern doesn't contain any parseable data", iterator.pos);
        }
        return new ValidationStepChecker(checks);
    }

    private static void parsePattern(CharIterator iterator, List<ValidationStepCheck> result) throws ParseException {
        List<ValidationStepCheck> preconditions = null;
        ValidationStepCheck lastCheck = null;
        int pos = -1;
        do {
            pos = iterator.pos;
            switch (iterator.getCurrent()) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '<': 
                case '=': 
                case '>': {
                    lastCheck = ValidationStepCheckerParser.parseNumber(iterator);
                    if (preconditions != null) {
                        lastCheck.setPreconditionalChecks(preconditions);
                        preconditions = null;
                    }
                    result.add(lastCheck);
                    break;
                }
                case '+': {
                    if (lastCheck == null) {
                        throw new ParseException("Unsupported pattern", iterator.pos);
                    }
                    lastCheck.setForAllFollowingVersionParts(true);
                    iterator.next();
                    break;
                }
                case '*': {
                    lastCheck = new OkCheck();
                    result.add(lastCheck);
                    if (preconditions != null) {
                        lastCheck.setPreconditionalChecks(preconditions);
                        preconditions = null;
                    }
                    iterator.next();
                    break;
                }
                case ',': {
                    iterator.next();
                    break;
                }
                case '[': {
                    preconditions = ValidationStepCheckerParser.parsePrecondition(iterator);
                    break;
                }
                default: {
                    throw new ParseException("Unexpected character in pattern!", iterator.pos);
                }
            }
        } while (iterator.pos != pos && !iterator.completelyProcessed());
    }

    private static List<ValidationStepCheck> parsePrecondition(CharIterator iterator) throws ParseException {
        block3: {
            char c = iterator.getCurrent();
            if (c != '[') {
                throw new ParseException("Unexpected character in pattern!", iterator.pos);
            }
            ValidationStepCheckerParser.increment(iterator);
            ArrayList<ValidationStepCheck> result = new ArrayList<ValidationStepCheck>();
            try {
                ValidationStepCheckerParser.parsePattern(iterator, result);
            }
            catch (ParseException e) {
                if (iterator.getCurrent() != ']') break block3;
                ValidationStepCheckerParser.increment(iterator);
                return result;
            }
        }
        throw new ParseException("Unexpected character in pattern!", iterator.pos);
    }

    private static ValidationStepCheck parseNumber(CharIterator iterator) throws ParseException {
        CompareOperator operator = CompareOperator.LESSTHAN;
        char c = iterator.getCurrent();
        switch (c) {
            case '>': {
                operator = CompareOperator.GREATERTHAN;
                ValidationStepCheckerParser.increment(iterator);
                break;
            }
            case '<': {
                operator = CompareOperator.LESSTHAN;
                ValidationStepCheckerParser.increment(iterator);
                break;
            }
            case '=': {
                operator = CompareOperator.EQUAL;
                ValidationStepCheckerParser.increment(iterator);
                break;
            }
        }
        boolean minus = false;
        switch (c) {
            case '-': {
                minus = true;
                ValidationStepCheckerParser.increment(iterator);
                break;
            }
            case '+': {
                ValidationStepCheckerParser.increment(iterator);
                break;
            }
        }
        StringBuilder sb = new StringBuilder();
        while (Character.isDigit(iterator.getCurrent())) {
            sb.append(iterator.getCurrent());
            if (iterator.next()) continue;
        }
        if (sb.length() == 0) {
            throw new ParseException("No digit detected!", iterator.pos);
        }
        int value = Integer.parseInt(sb.toString());
        if (minus) {
            value *= -1;
        }
        return new ValueCheck(operator, value);
    }

    private static void increment(CharIterator iterator) throws ParseException {
        if (!iterator.next()) {
            throw new ParseException("The end of pattern is reached but another char is expected", iterator.pos);
        }
    }

    private static class CharIterator {
        private char[] chars;
        private int pos;

        public CharIterator(String s) {
            this.chars = s.toCharArray();
            this.pos = 0;
        }

        public char getCurrent() {
            return this.chars[this.pos];
        }

        public boolean next() {
            return ++this.pos < this.chars.length;
        }

        public boolean completelyProcessed() {
            return this.pos >= this.chars.length;
        }
    }
}

