/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.validation.x509.chain.CertChainValidationStep;
import de.governikus.csl.validation.x509.chain.ValidationStepCheck;
import java.util.List;

public class ValidationStepChecker {
    private List<ValidationStepCheck> checks;
    private int checkLength;

    public ValidationStepChecker(List<ValidationStepCheck> checks) {
        this.checks = checks;
        this.checkLength = checks.size();
    }

    public boolean check(int[] map) {
        int pos = 0;
        ValidationStepCheck lastCheck = null;
        for (int i = 0; i < map.length; ++i) {
            ValidationStepCheck check = null;
            if (lastCheck != null && lastCheck.isForAllFollowingPositions()) {
                check = lastCheck;
            } else if (pos < this.checkLength) {
                check = this.checks.get(pos++);
            } else {
                return false;
            }
            boolean b = check.check(map, i);
            if (!b) {
                return false;
            }
            lastCheck = check;
        }
        return true;
    }

    public boolean check(CertChainValidationStep depth) {
        return this.check(depth.getMap());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.checkLength;
        result = 31 * result + (this.checks == null ? 0 : this.checks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationStepChecker other = (ValidationStepChecker)obj;
        if (this.checkLength != other.checkLength) {
            return false;
        }
        return !(this.checks == null ? other.checks != null : !this.checks.equals(other.checks));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.checkLength; ++i) {
            sb.append(this.checks.get(i).toString());
            if (i >= this.checkLength - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

