/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.TrustAnchorPolicy;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;

public class TrustedAnchorDeterminator
implements CertificateProcessor<Void> {
    private TrustAnchorPolicy trustAnchorPolicy;

    public TrustedAnchorDeterminator(TrustAnchorPolicy trustAnchorPolicy) {
        this.trustAnchorPolicy = trustAnchorPolicy;
    }

    boolean useServiceAsTrustedAnchor(boolean isAllowedService, boolean isServiceSupervised) {
        if (!isServiceSupervised || this.trustAnchorPolicy == TrustAnchorPolicy.NO_TRUST_ANCHORS) {
            return false;
        }
        return this.trustAnchorPolicy == TrustAnchorPolicy.ALL_EUMS || isAllowedService;
    }

    @Override
    public Void process(AttributeCertificateSignature attributeCert) {
        return null;
    }

    @Override
    public Void process(X509Data cert) {
        ServiceInformation serviceInformation = cert.getServiceInformation();
        if (serviceInformation != null) {
            ExtendedTLInformation tlInfo = cert.getTslInformation();
            if (tlInfo == null || tlInfo.getTslType() != TLType.OFFICIAL) {
                cert.setTrustedAnchor(false);
                return null;
            }
            boolean allowedService = this.isAllowedService(serviceInformation.getServiceTypeIdentifier());
            boolean serviceSupervised = this.isServiceSupervised(serviceInformation.getServiceStatus());
            boolean isTrustedAnchor = this.useServiceAsTrustedAnchor(allowedService, serviceSupervised);
            cert.setTrustedAnchor(isTrustedAnchor);
        }
        return null;
    }

    private boolean isServiceSupervised(ServiceStatus serviceStatus) {
        return serviceStatus == ServiceStatus.GRANTED || serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL || serviceStatus == ServiceStatus.UNDER_SUPERVISION || serviceStatus == ServiceStatus.SUPERVISION_IN_CESSATION || serviceStatus == ServiceStatus.ACCREDITED || serviceStatus == ServiceStatus.SET_BY_NATIONAL_LAW;
    }

    private boolean isAllowedService(ServiceType serviceTypeIdentifier) {
        return serviceTypeIdentifier == ServiceType.CA_QC || serviceTypeIdentifier == ServiceType.CA_PKC || serviceTypeIdentifier == ServiceType.OCSP || serviceTypeIdentifier == ServiceType.OCSP_QC || serviceTypeIdentifier == ServiceType.CRL || serviceTypeIdentifier == ServiceType.CRL_QC || serviceTypeIdentifier == ServiceType.NATIONAL_ROOT_CA_QC || serviceTypeIdentifier == ServiceType.TSA || serviceTypeIdentifier == ServiceType.QTST || serviceTypeIdentifier == ServiceType.TSS_QC || serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES;
    }
}

