/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.utils.TrustStoreResponse;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;

public class TrustStoreInformationRetriever
implements CertificateProcessor<Void> {
    private TrustStore trustStore;
    private Date referenceDate;

    public TrustStoreInformationRetriever(TrustStore trustStore, Date referenceDate) {
        this.trustStore = trustStore;
        this.referenceDate = referenceDate;
    }

    @Override
    public Void process(AttributeCertificateSignature attributeCert) {
        return null;
    }

    @Override
    public Void process(X509Data cert) {
        TrustStoreResponse certificateInformation;
        if (cert.getServiceInformation() == null && (certificateInformation = this.trustStore.getCertificateInformation(cert.getCert(), this.referenceDate)) != null) {
            cert.setServiceInformation(certificateInformation.getServiceInformation());
            cert.setTslInformation(certificateInformation.getTslInformation());
        }
        return null;
    }
}

