/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.PolicyEvaluationState;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.CertificateQualityConstraints;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validation.SigGCACertStore;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDeterminator
implements CertificateProcessor<EvaluatedValidationPolicyType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyDeterminator.class);
    private static final String UNKNOWN = "UNKNOWN";
    private final PolicyProviderManager policyProviderManager;
    private SigGCACertStore sigGCertStore;

    public PolicyDeterminator(PolicyProviderManager policyProviderManager) {
        try {
            this.sigGCertStore = SigGCACertStore.getInstance();
        }
        catch (CoreException e) {
            LOGGER.warn("Can't get SigG-CA-CertStore instance. Automatic policy-determination may produce false results", (Throwable)e);
        }
        this.policyProviderManager = policyProviderManager;
    }

    PolicyDeterminator(SigGCACertStore certStore, PolicyProviderManager policyProviderManager) {
        this.sigGCertStore = certStore;
        this.policyProviderManager = policyProviderManager;
    }

    @Override
    public EvaluatedValidationPolicyType process(AttributeCertificateSignature attrCert) {
        CertificateQualityResult certificateQualityResult;
        String country = this.getCountry(attrCert);
        if (country.equals(UNKNOWN) || country.isEmpty()) {
            return this.getEvaluatedAesPolicy();
        }
        QualityResult qualityResult = attrCert.getQualityResult();
        if (qualityResult != null && (certificateQualityResult = qualityResult.getCertificateQualityResult()) != null) {
            return this.getPolicyByQuality(certificateQualityResult, attrCert);
        }
        return this.getEvaluatedAesPolicy();
    }

    @Override
    public EvaluatedValidationPolicyType process(X509Data cert) {
        CertificateQualityResult certificateQualityResult;
        String country = this.getCountry(cert);
        if (country.equals(UNKNOWN) || country.isEmpty()) {
            return this.getEvaluatedAesPolicy();
        }
        EvaluatedValidationPolicyType tspPolicy = this.getPolicyForTimestampingService(cert);
        if (tspPolicy != null) {
            return tspPolicy;
        }
        QualityResult qualityResult = cert.getQualityResult();
        if (qualityResult != null && (certificateQualityResult = qualityResult.getCertificateQualityResult()) != null) {
            return this.getPolicyByQuality(certificateQualityResult, cert);
        }
        return this.getEvaluatedAesPolicy();
    }

    private EvaluatedValidationPolicyType getPolicyByQuality(CertificateQualityResult certQualityResult, BaseCertificateSignature<?> cert) {
        String country = this.getCountry(cert);
        if (country.equalsIgnoreCase("DE")) {
            return this.getPolicyByQualityDE(certQualityResult, cert);
        }
        Quality assumedQuality = certQualityResult.getAssumedQuality();
        TLType tlType = certQualityResult.getTLType();
        CertificateQualityConstraints constraints = certQualityResult.getConstraints();
        String serviceTypeIdentifier = null;
        if (constraints != null) {
            serviceTypeIdentifier = constraints.getServiceTypeIdentifier();
        }
        if (TLType.GOVERNIKUS.equals((Object)tlType) || TLType.CUSTOM.equals((Object)tlType) || "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC".equals(serviceTypeIdentifier) && TLType.OFFICIAL.equals((Object)tlType)) {
            return this.getEvaluatedAesPolicy();
        }
        if (Quality.QC.equals((Object)assumedQuality)) {
            return this.createEvaluatedPolicy(this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA());
        }
        return this.getEvaluatedAesPolicy();
    }

    private EvaluatedValidationPolicyType getPolicyByQualityDE(CertificateQualityResult certQualityResult, BaseCertificateSignature<?> cert) {
        CertificateQualityConstraints constraints;
        if (Optional.ofNullable(certQualityResult).map(CertificateQualityResult::getAssumedQuality).orElse(Quality.DC) != Quality.QC) {
            return this.getEvaluatedAesPolicy();
        }
        boolean hasQcCompliance = false;
        if (certQualityResult != null && (constraints = certQualityResult.getConstraints()) != null) {
            hasQcCompliance = constraints.getQCStatements().contains("0.4.0.1862.1.1");
        }
        if (hasQcCompliance && this.sigGCertStore.isQualifiedSigGCertificate((X509CertificateBaseFacade<?>)cert.getCert())) {
            return this.createEvaluatedPolicy(this.policyProviderManager.getPolicyProvider().getSigG_QES_TA());
        }
        return this.createEvaluatedPolicy(this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA_DE());
    }

    private EvaluatedValidationPolicyType getPolicyForTimestampingService(X509Data cert) {
        if (cert.hasEuQC()) {
            if (this.getCountry(cert).equalsIgnoreCase("de")) {
                return this.createEvaluatedPolicy(this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA_DE());
            }
            return this.createEvaluatedPolicy(this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA());
        }
        ServiceInformation serviceInformation = cert.getServiceInformation();
        if (serviceInformation == null) {
            serviceInformation = cert.getIssuerServiceInformation();
        }
        if (serviceInformation != null) {
            ExtendedTLInformation tslInformation = cert.getTslInformation();
            boolean officialTL = false;
            if (tslInformation != null) {
                officialTL = tslInformation.getTslType() == TLType.OFFICIAL;
            }
            ServiceType serviceTypeIdentifier = serviceInformation.getServiceTypeIdentifier();
            ValidationPolicyType policy = null;
            if (serviceTypeIdentifier == ServiceType.QTST) {
                policy = officialTL ? (this.getCountry(cert).equalsIgnoreCase("de") ? this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA_DE() : this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA()) : this.policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG();
            } else if (serviceTypeIdentifier == ServiceType.TSA || serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES || serviceTypeIdentifier == ServiceType.TSS_QC) {
                policy = this.policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG();
            }
            if (policy != null) {
                return this.createEvaluatedPolicy(policy);
            }
        }
        return null;
    }

    private EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy) {
        EvaluatedValidationPolicyType createEvaluatedPolicy = PolicyEvaluator.createEvaluatedPolicy((ValidationPolicyType)policy, (PolicyOrigin)PolicyOrigin.AUTOMATIC_DETERMINATION, (boolean)false, (PolicyProviderManager)this.policyProviderManager);
        createEvaluatedPolicy.setEvaluationState(PolicyEvaluationState.TRUSTED_POLICY);
        return createEvaluatedPolicy;
    }

    private EvaluatedValidationPolicyType getEvaluatedAesPolicy() {
        ValidationPolicyType policy = this.policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG();
        return this.createEvaluatedPolicy(policy);
    }

    private String getCountry(BaseCertificateSignature<?> cert) {
        return this.getCountry((X509CertificateBaseFacade<?>)cert.getCert());
    }

    private String getCountry(X509CertificateBaseFacade<?> cert) {
        return Optional.ofNullable(cert).map(CertificateBase::getIssuerX500Principal).map(LDAPEntry::new).map(LDAPEntry::getCountry).orElse(UNKNOWN);
    }

    public ValidationPolicyType process(Timestamp timestamp) {
        String country;
        ValidationPolicyType policy = null;
        policy = timestamp.hasEUQCStatement() ? ((country = this.getCountry((X509CertificateBaseFacade<?>)timestamp.getSigningCertificate())).equalsIgnoreCase("de") ? this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA_DE() : this.policyProviderManager.getPolicyProvider().getEIDAS_QES_TA()) : (this.sigGCertStore.isQualifiedSigGCertificate((X509CertificateBaseFacade<?>)timestamp.getSigningCertificate()) ? this.policyProviderManager.getPolicyProvider().getSigG_QES_TA() : this.policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG());
        return policy;
    }
}

