/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;
import java.util.List;

class CertficateChainNode<T> {
    private T item;
    private int childPtr;
    private CertficateChainNode<? extends BaseCertificateSignature<?>> parent;
    private boolean childsQueried;
    private List<CertficateChainNode<X509Data>> childs;
    private Date referenceDate;

    CertficateChainNode(T item) {
        this.item = item;
        this.childPtr = 0;
    }

    CertficateChainNode(T item, Date referenceDate) {
        this.item = item;
        this.childPtr = 0;
        this.referenceDate = referenceDate;
    }

    boolean isChildsQueried() {
        return this.childsQueried;
    }

    T getItem() {
        return this.item;
    }

    void setChildsQueried(boolean childsQueried) {
        this.childsQueried = childsQueried;
    }

    CertficateChainNode<? extends BaseCertificateSignature<?>> getParent() {
        return this.parent;
    }

    void setParent(CertficateChainNode<? extends BaseCertificateSignature<?>> parent) {
        this.parent = parent;
    }

    List<CertficateChainNode<X509Data>> getChilds() {
        return this.childs;
    }

    void setChilds(List<CertficateChainNode<X509Data>> childs) {
        this.childs = childs;
    }

    CertficateChainNode<X509Data> getNextChild() {
        if (this.childs != null && this.childPtr < this.childs.size()) {
            return this.childs.get(this.childPtr++);
        }
        return null;
    }

    public Date getReferenceDate() {
        return this.referenceDate;
    }
}

