/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import java.util.Arrays;

public class CertChainValidationStep {
    private int[] map;

    public CertChainValidationStep(int lvl) {
        this.map = new int[]{lvl};
    }

    public CertChainValidationStep(CertChainValidationStep other) {
        this(other, other.map.length);
    }

    private CertChainValidationStep(CertChainValidationStep base, int length) {
        this.map = Arrays.copyOf(base.map, length);
    }

    public CertChainValidationStep add(int lvl) {
        int length = this.map.length;
        CertChainValidationStep inst = new CertChainValidationStep(this, length + 1);
        inst.map[length] = lvl;
        return inst;
    }

    public CertChainValidationStep removeLast() {
        return new CertChainValidationStep(this, this.map.length - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int a : this.map) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(a);
        }
        return sb.toString();
    }

    public int getCurrentDepth() {
        return this.map.length;
    }

    public int getCurrentPositionInCertChain() {
        return this.map[this.map.length - 1];
    }

    int[] getMap() {
        return this.map;
    }
}

