/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.chain.CertChain;
import de.governikus.csl.validation.x509.chain.CertChainItemGenerator;
import de.governikus.csl.validation.x509.chain.CertficateChainNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CertChainIterator<T extends BaseCertificateSignature<?>>
implements Iterator<CertChain<T>> {
    private CertChainItemGenerator generator;
    private Deque<X509Data> stack;
    private CertficateChainNode<? extends BaseCertificateSignature<?>> currentNode;
    private T endEntityCertificate;

    public CertChainIterator(CertChainItemGenerator generator) {
        this.generator = generator;
    }

    public void init(T start, Date referenceDate) {
        this.endEntityCertificate = start;
        this.currentNode = new CertficateChainNode<T>(start, referenceDate);
        this.stack = new ArrayDeque<X509Data>();
        this.goToNextLeaf();
    }

    private boolean goToNextLeaf() {
        BaseCertificateSignature<?> item;
        List<X509Data> childs;
        if (!(this.currentNode.isChildsQueried() || (childs = this.generator.getNextNodesFromCertStore(item = this.currentNode.getItem(), this.stack, this.currentNode.getReferenceDate())) == null || childs.isEmpty() || item.isSelfSigned())) {
            ArrayList<CertficateChainNode<X509Data>> childItems = new ArrayList<CertficateChainNode<X509Data>>();
            for (X509Data t : childs) {
                CertficateChainNode<X509Data> child = new CertficateChainNode<X509Data>(t, item.getSigningTime().getDate());
                child.setParent(this.currentNode);
                childItems.add(child);
            }
            this.currentNode.setChilds(childItems);
            this.currentNode.setChildsQueried(true);
        }
        if (this.currentNode.getChilds() == null) {
            return false;
        }
        CertficateChainNode<X509Data> nextChild = this.currentNode.getNextChild();
        if (nextChild != null) {
            this.stack.push(nextChild.getItem());
            this.currentNode = nextChild;
            this.goToNextLeaf();
            return true;
        }
        return false;
    }

    private void stepBackToNextLeaf() {
        CertficateChainNode<BaseCertificateSignature<?>> parent = this.currentNode.getParent();
        if (parent == null) {
            this.currentNode = null;
            return;
        }
        this.stack.pop();
        this.currentNode = parent;
        if (!this.goToNextLeaf()) {
            this.stepBackToNextLeaf();
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentNode != null;
    }

    @Override
    public CertChain<T> next() {
        if (this.currentNode == null) {
            throw new NoSuchElementException();
        }
        ArrayDeque<X509Data> result = new ArrayDeque<X509Data>();
        result.addAll(this.stack);
        CertChain<T> chain = new CertChain<T>(this.endEntityCertificate, result);
        this.stepBackToNextLeaf();
        this.setIssuerServiceInformation(chain);
        return chain;
    }

    private void setIssuerServiceInformation(CertChain<T> chain) {
        Object current = chain.getEndEntityCertificate();
        Deque<X509Data> caCertificates = chain.getCACertificates();
        Iterator<X509Data> iterator = caCertificates.descendingIterator();
        while (iterator.hasNext()) {
            X509Data ca = iterator.next();
            ServiceInformation serviceInformation = ca.getServiceInformation();
            ((BaseCertificateSignature)((Object)current)).setIssuerServiceInformation(serviceInformation);
            current = ca;
        }
    }
}

