/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509.chain;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.CertStoreResponseProcessor;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.X509Plugin;
import de.governikus.csl.validation.x509.chain.TrustStoreInformationApplier;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertChainItemGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertChainItemGenerator.class);
    private CertStore certStore;
    private X509Plugin plugin;

    public CertChainItemGenerator(CertStore certStore, X509Plugin plugin) {
        this.certStore = certStore;
        this.plugin = plugin;
    }

    public List<X509Data> getNextNodesFromCertStore(BaseCertificateSignature<?> currentNode, Deque<X509Data> currentChain, Date referenceDate) {
        Object cert = currentNode.getCert();
        CertStoreResponse certStoreResponse = this.certStore.getSigningCertificates(cert, referenceDate);
        if (certStoreResponse != null) {
            InformationSource informationSource = certStoreResponse.getInformationSource();
            List matchingCertificates = certStoreResponse.getMatchingCertificates();
            if (matchingCertificates != null) {
                ArrayList<X509Data> result = new ArrayList<X509Data>();
                for (CertificateData matchingCertData : matchingCertificates) {
                    X509Certificate matchingCertificate = matchingCertData.getCertificate();
                    Object wrappedCertificate = cert.getWrappedCertificate();
                    if (wrappedCertificate.equals(matchingCertificate)) {
                        if (!matchingCertificate.getSubjectX500Principal().toString().equals(matchingCertificate.getIssuerX500Principal().toString())) continue;
                        currentNode.setSelfSigned(true);
                        continue;
                    }
                    try {
                        X509Data issuer = this.plugin.parseAsSignature(matchingCertificate);
                        issuer.setDownloadURL(matchingCertData.getCertificateURL());
                        boolean loop = false;
                        for (X509Data chainEntry : currentChain) {
                            if (!chainEntry.equals((Object)issuer)) continue;
                            loop = true;
                            chainEntry.setSelfSigned(true);
                            break;
                        }
                        if (loop) break;
                        issuer.setInformationSource(informationSource);
                        certStoreResponse.apply((CertStoreResponseProcessor)new TrustStoreInformationApplier(issuer, matchingCertData));
                        result.add(issuer);
                    }
                    catch (ValidatePluginException e) {
                        LOGGER.error("Can't process certificate.", (Throwable)((Object)e));
                    }
                }
                return result;
            }
        }
        return null;
    }
}

