/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.CertificateDocumentValidator;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.PublicKeyCertificateValidator;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.X509DataExtractor;
import de.governikus.csl.validation.x509.criteria.CheckCertificateReferences;
import de.governikus.csl.validation.x509.criteria.CheckChainEnd;
import de.governikus.csl.validation.x509.criteria.CheckTrustStoreReliability;
import de.governikus.csl.validation.x509.criteria.ExtensionCheck;
import de.governikus.csl.validation.x509.criteria.RevocationStatusChecker;
import de.governikus.csl.validation.x509.criteria.RevocationTrustCheck;
import de.governikus.csl.validation.x509.criteria.TLValidityCheck;
import de.governikus.csl.validation.x509.criteria.ValidityCheck;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

@PluginType(id=Plugin.PluginID.VALIDATE_X509, type=ValidatePlugin.class)
public class X509Plugin
extends AbstractDocumentPlugin<BaseObjectToValidate<X509Data>, X509Data, ObjectValidationResult, PublicKeyCertificateValidationResult, CertificateValidationContext> {
    public X509Plugin() {
        super(X509Data.class, CertificateValidationContext.class);
    }

    @Override
    public BaseObjectToValidate<X509Data> parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        this.logger.debug("Parse X509 from stream");
        Document signatureDocument = doc.getSignature();
        X509Certificate cert = null;
        try (InputStream is = signatureDocument.getInputStream();){
            if (is.available() > 0xA00000) {
                throw new IllegalArgumentException("Data is too big for beeing a X.509");
            }
            cert = X509Plugin.parseCertificate(signatureDocument);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new ValidatePluginException(this, "Can't parse document", e);
        }
        if (cert == null) {
            throw new ValidatePluginException(this, "Can't parse document");
        }
        return this.parse(doc, cert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate parseCertificate(Document signatureDocument) throws IllegalArgumentException {
        if (X509Plugin.isCMS(signatureDocument)) {
            return null;
        }
        CertificateFactory factory = null;
        try {
            factory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        }
        catch (NoSuchProviderException | CertificateException e2) {
            throw new IllegalArgumentException("Can't create cert factory", e2);
        }
        try (InputStream stream = signatureDocument.getInputStream();){
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(stream);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            throw new IllegalArgumentException("Can't parse document", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCMS(Document signatureDocument) {
        try (InputStream stream = signatureDocument.getInputStream();
             ASN1InputStream asnStream = new ASN1InputStream(stream);){
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)asnStream.readObject());
            if (seq == null) return false;
            if (seq.size() <= 1) return false;
            if (!(seq.getObjectAt(0) instanceof ASN1ObjectIdentifier)) return false;
            if (!seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            // empty catch block
        }
        return false;
    }

    public BaseObjectToValidate<X509Data> parse(SignedData doc, X509Certificate x509) throws ValidatePluginException {
        BaseObjectToValidate result = new BaseObjectToValidate();
        result.setName(doc.getSignature().getName());
        ArrayList<X509Data> lbsowc = new ArrayList<X509Data>();
        result.setSignatures(lbsowc);
        X509Data signature = this.parseAsSignature(x509);
        signature.setInformationSource(InformationSource.REQUEST);
        lbsowc.add(signature);
        return result;
    }

    public X509Data parseAsSignature(X509Certificate x509) throws ValidatePluginException {
        ASN1OctetString octet;
        ASN1GeneralizedTime generalizedTime;
        X509Data signature = new X509Data();
        signature.setInformationSource(InformationSource.REQUEST);
        AlgorithmManager algorithmManager = this.configuration.getAlgorithmManager();
        String algorithm = x509.getSigAlgName();
        String oid = x509.getSigAlgOID();
        SignatureAlgorithm signatureAlgorithm = algorithmManager.getSignatureAlgorithmByJcaOidOrUrl(algorithm, oid, null);
        if (signatureAlgorithm == null) {
            signatureAlgorithm = algorithmManager.getSignatureAlgorithmByJCAName(algorithm);
        }
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setSignatureValue(x509.getSignature());
        signature.setType(SignedObjectType.CERTIFICATE);
        try {
            ByteArrayDocument bais = new ByteArrayDocument(x509.getTBSCertificate());
            signature.setSignedContent((Document)bais);
        }
        catch (CertificateEncodingException e) {
            throw new ValidatePluginException(this, "Can't get signed data from certificate", e);
        }
        Date claimedSigningTime = x509.getNotBefore();
        byte[] certGenerationDate = x509.getExtensionValue("1.3.36.8.3.1");
        if (certGenerationDate != null && (generalizedTime = ASN1GeneralizedTime.getInstance((Object)(octet = ASN1OctetString.getInstance((Object)certGenerationDate)).getOctets())) != null) {
            try {
                claimedSigningTime = generalizedTime.getDate();
            }
            catch (ParseException e) {
                this.logger.info("Can't parse certificate generation time");
            }
        }
        if (claimedSigningTime != null) {
            signature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        signature.setCert(new X509CertificateImpl(x509));
        return signature;
    }

    @Override
    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        return SVPFactory.createObjectValidationResult((String)this.getID());
    }

    @Override
    protected PublicKeyCertificateValidationResult createSignatureValidationResultStructure() {
        return new PublicKeyCertificateValidationResult();
    }

    @Override
    public DataExtractor<? super X509Data, ? super PublicKeyCertificateValidationResult> getSignatureDataExtractor() {
        return new X509DataExtractor();
    }

    @Override
    public CertificateValidationContext createContext(X509Data signature, ValidationPolicyType policy) {
        return new CertificateValidationContext(policy);
    }

    @Override
    public SignatureValidator<?, ? extends PublicKeyCertificateValidationResult, CertificateValidationContext> createSignatureValidator(X509Data signature, CertificateValidationContext context, List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> customCriteria) {
        return new PublicKeyCertificateValidator(this.configuration.getCertValidator(), signature, context);
    }

    public static List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> result = new ArrayList<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>>();
        result.add(new ExtensionCheck());
        result.add(new CheckCertificateReferences());
        result.add(new RevocationStatusChecker());
        result.add(new CheckTrustStoreReliability());
        result.add(new ValidityCheck());
        result.add(new TLValidityCheck());
        result.add(new RevocationTrustCheck());
        result.add(new CheckChainEnd());
        return result;
    }

    @Override
    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_X509;
    }

    @Override
    public SignatureValidator<?, ? extends PublicKeyCertificateValidationResult, CertificateValidationContext> createSignatureValidator(X509Data signature, Date validationDate, ValidationPolicyType policy, DocumentValidationContext documentContext) {
        CertificateValidationContext context = this.createContext(signature, policy);
        context.setConfiguration(this.configuration);
        context.extendContext((Signature)signature, validationDate, (ValidatePolicy)policy);
        context.setDocumentValidationContext(documentContext);
        return this.createSignatureValidator(signature, context, null);
    }

    @Override
    public ObjectValidator getDocumentValidator(BaseObjectToValidate<X509Data> parsedDocument, IncludedFileValidator requestProcessor) {
        return new CertificateDocumentValidator<X509Data, PublicKeyCertificateValidationResult>(this, parsedDocument, this.configuration.getCertValidator());
    }
}

