/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validate.svp.Principal;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validate.svp.ServiceInfo;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.dataExtractor.DefaultSignatureDataExtractor;
import de.governikus.csl.validation.x509.X509Data;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class X509DataExtractor
extends DefaultSignatureDataExtractor<X509Data, PublicKeyCertificateValidationResult> {
    @Override
    public void extractData(X509Data source, PublicKeyCertificateValidationResult destination) {
        super.extractData(source, destination);
        X509Certificate cs = (X509Certificate)((X509CertificateImpl)source.getCert()).getWrappedCertificate();
        destination.setCert((X509CertificateImpl)source.getCert());
        X500Principal subject = cs.getSubjectX500Principal();
        Principal se = this.getAuthorityInfos(subject);
        destination.setSubjectInfos(se);
        X500Principal issuer = cs.getIssuerX500Principal();
        Principal ie = this.getAuthorityInfos(issuer);
        destination.setIssuerInfos(ie);
        destination.setInformationSource(source.getInformationSource());
        ExtendedTLInformation tslInformation = source.getTslInformation();
        if (tslInformation != null) {
            destination.setTSLInfo(tslInformation.getTslInfo());
            destination.setTslExtensionInfo(tslInformation.getTslExtensionInfo());
            destination.setLotlInfo(tslInformation.getLotlInfo());
        }
        QualityResult qualityResult = source.getQualityResult();
        destination.setQualityResult(qualityResult);
        CertificateQualificationInformation qualityInformation = source.getQualityInformation();
        destination.setQualityInformation(qualityInformation);
        destination.setTrustedAnchor(source.isTrustedAnchor());
        destination.setValidityModel(source.getValidityModel());
        ServiceInformation serviceInformation = source.getServiceInformation();
        if (serviceInformation != null) {
            destination.setTrustServiceProviderInformation(serviceInformation.getTspInformation());
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceStatus(serviceInformation.getServiceStatus());
            serviceInfo.setServiceTypeIdentifier(serviceInformation.getServiceTypeIdentifier());
            serviceInfo.setValidFrom(serviceInformation.getValidFrom());
            destination.setServiceInfo(serviceInfo);
        }
        destination.setDownloadUrl(source.getDownloadURL());
        TimestampQuality timestampQuality = source.getTimestampQuality();
        ValidationMessageCode timestampQualificationMsgCode = source.getTimestampQualificationMsgCode();
        if (timestampQuality != null && timestampQualificationMsgCode != null) {
            destination.setTimestampQuality(timestampQuality);
            destination.setTimestampQualificationMsgCode(timestampQualificationMsgCode);
        }
    }

    private Principal getAuthorityInfos(X500Principal principal) {
        LDAPEntry entry = new LDAPEntry(principal);
        Principal p = new Principal();
        p.setCommonName(entry.getCommonName());
        p.setCountry(entry.getCountry());
        p.setOrganisation(entry.getOrganisation());
        return p;
    }
}

