/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import java.security.cert.X509Certificate;

public class X509Data
extends BaseCertificateSignature<X509CertificateImpl> {
    private InformationSource informationSource;
    private String downloadURL;
    private boolean isSelfSigned = false;
    private boolean isTrustedAnchor = false;
    private X509Data precursorInCertChain;
    private boolean euQC;
    private TimestampQuality timestampQuality;
    private ValidationMessageCode timestampQualificationMsgCode;

    public SignedObjectType getType() {
        return SignedObjectType.CERTIFICATE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cert == null ? 0 : ((X509CertificateImpl)this.cert).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof X509Data) {
            X509Data d = (X509Data)((Object)obj);
            return ((X509Certificate)((X509CertificateImpl)this.cert).getWrappedCertificate()).equals(((X509CertificateImpl)d.cert).getWrappedCertificate());
        }
        return false;
    }

    public InformationSource getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(InformationSource informationSource) {
        this.informationSource = informationSource;
    }

    @Override
    public boolean isSelfSigned() {
        return this.isSelfSigned;
    }

    @Override
    public void setSelfSigned(boolean isSelfSigned) {
        this.isSelfSigned = isSelfSigned;
    }

    @Override
    public boolean isTrustedAnchor() {
        return this.isTrustedAnchor;
    }

    public void setTrustedAnchor(boolean isTrustedAnchor) {
        this.isTrustedAnchor = isTrustedAnchor;
    }

    public X509Data getPrecursorInCertChain() {
        return this.precursorInCertChain;
    }

    public void setPrecursorInCertChain(X509Data precursorInCertChain) {
        this.precursorInCertChain = precursorInCertChain;
    }

    @Override
    public <T> T process(CertificateProcessor<T> processor) {
        return processor.process(this);
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public boolean hasEuQC() {
        return this.euQC;
    }

    public void setEuQC(boolean euQC) {
        this.euQC = euQC;
    }

    public TimestampQuality getTimestampQuality() {
        return this.timestampQuality;
    }

    public void setTimestampQuality(TimestampQuality timestampQuality) {
        this.timestampQuality = timestampQuality;
    }

    public ValidationMessageCode getTimestampQualificationMsgCode() {
        return this.timestampQualificationMsgCode;
    }

    public void setTimestampQualificationMsgCode(ValidationMessageCode timestampQualificationMsgCode) {
        this.timestampQualificationMsgCode = timestampQualificationMsgCode;
    }
}

