/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.List;

public class ReferenceDateDeterminator
implements CertificateProcessor<Date> {
    private CertificateValidationContext context;
    private List<TypedDate> potentialPOEs;

    public ReferenceDateDeterminator(CertificateValidationContext context, List<TypedDate> potentialPOEs) {
        this.context = context;
        this.potentialPOEs = potentialPOEs;
    }

    @Override
    public Date process(AttributeCertificateSignature attributeCert) {
        return attributeCert.getSigningTime().getDate();
    }

    @Override
    public Date process(X509Data cert) {
        X509CertificateImpl certificate = (X509CertificateImpl)cert.getCert();
        SignedObjectType signedObjectType = this.context.getSignedObjectTypeContext();
        if (signedObjectType == null) {
            signedObjectType = this.determineObjectType(certificate);
        }
        switch (signedObjectType) {
            case OCSP: 
            case CRL: 
            case TIMESTAMP: {
                return this.getClaimedSigningTime(cert);
            }
        }
        return cert.getSigningTime().getDate();
    }

    private Date getClaimedSigningTime(X509Data cert) {
        Date claimedSiningTime = this.getClaimedSiningTime(this.potentialPOEs);
        if (claimedSiningTime == null) {
            claimedSiningTime = cert.getSigningTime().getDate();
        }
        return claimedSiningTime;
    }

    private SignedObjectType determineObjectType(X509CertificateImpl certificate) {
        if (this.isTimestampingCert(certificate)) {
            return SignedObjectType.TIMESTAMP;
        }
        return SignedObjectType.DATA;
    }

    private boolean isTimestampingCert(X509CertificateImpl cert) {
        List extendedKeyUsage;
        try {
            extendedKeyUsage = cert.getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            return false;
        }
        if (extendedKeyUsage == null || extendedKeyUsage.size() != 1) {
            return false;
        }
        String keyUsageOID = (String)extendedKeyUsage.get(0);
        return keyUsageOID.equals("1.3.6.1.5.5.7.3.8");
    }

    private Date getClaimedSiningTime(List<TypedDate> potentialPOEs) {
        if (potentialPOEs == null) {
            return null;
        }
        Date bestDate = null;
        for (TypedDate td : potentialPOEs) {
            DateType type = td.getType();
            if (type != DateType.CLAIMED_SIGNING_TIME && type != DateType.SIGNATURE_TIME_MARK) continue;
            Date date = td.getDate();
            if (bestDate != null && bestDate.compareTo(date) <= 0) continue;
            bestDate = date;
        }
        return bestDate;
    }
}

