/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.X509Data;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PublicKeyCertificateValidator
implements SignatureValidator<X509Data, PublicKeyCertificateValidationResult, CertificateValidationContext> {
    private CertificateValidator validator;
    private X509Data signature;
    private CertificateValidationContext context;

    public PublicKeyCertificateValidator(CertificateValidator validator, X509Data signature, CertificateValidationContext context) {
        this.validator = validator;
        this.signature = signature;
        this.context = context;
    }

    @Override
    public PublicKeyCertificateValidationResult validateSignature() {
        return this.validator.validate(this.signature, this.context, this.listPossiblePOEs(this.context), this.listPossibleAlgValidationTimes(this.context)).getCertificateValidationResult();
    }

    private List<TypedDate> listPossiblePOEs(SignatureValidationContext context) {
        Date validationDate;
        ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
        TypedDate bestSigningTime = context.getBestSigningTime();
        if (bestSigningTime != null) {
            possiblePOEs.add(bestSigningTime);
        }
        if ((validationDate = context.getValidationDate()) != null) {
            possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
        }
        return possiblePOEs;
    }

    private List<TypedDate> listPossibleAlgValidationTimes(SignatureValidationContext context) {
        Date validationDate;
        ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
        TypedDate bestSigningTime = context.getBestAlgValidationTime();
        if (bestSigningTime != null) {
            possiblePOEs.add(bestSigningTime);
        }
        if ((validationDate = context.getValidationDate()) != null) {
            possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
        }
        return possiblePOEs;
    }

    @Override
    public CertificateValidationContext getContext() {
        return this.context;
    }
}

