/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.jeebackend.trace.TraceContextDecorator;
import de.governikus.csl.jeebackend.trace.TraceContextTypedCallableDecorator;
import de.governikus.csl.tsl.ManagedTL;
import de.governikus.csl.tsl.SecureTLManager;
import de.governikus.csl.tsl.TLManager;
import de.governikus.csl.tsl.TLManagerEntry;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.RevocationValueValidationDepth;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.commons.CRLReason;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyNormalizer;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.quality.ETSIQualificationProcessor;
import de.governikus.csl.validation.quality2.QualityProcessor;
import de.governikus.csl.validation.quality2.impl.DefaultCertificateQualityProcessor;
import de.governikus.csl.validation.quality2.impl.DefaultConcernProcessor;
import de.governikus.csl.validation.quality2.impl.DefaultQualityProcessor;
import de.governikus.csl.validation.quality2.impl.DefaultSignatureQualityProcessor;
import de.governikus.csl.validation.tsp.TimestampQualityDeterminator;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertChainValidator;
import de.governikus.csl.validation.x509.CheckCertCall;
import de.governikus.csl.validation.x509.FutureFacade;
import de.governikus.csl.validation.x509.ReferenceDateDeterminator;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.X509Plugin;
import de.governikus.csl.validation.x509.chain.CertChain;
import de.governikus.csl.validation.x509.chain.CertChainItemGenerator;
import de.governikus.csl.validation.x509.chain.CertChainIterator;
import de.governikus.csl.validation.x509.chain.CertChainValidationStep;
import de.governikus.csl.validation.x509.chain.IsCertificateSelfSignedOrTrustedAnchor;
import de.governikus.csl.validation.x509.chain.PolicyDeterminator;
import de.governikus.csl.validation.x509.chain.TrustStoreInformationRetriever;
import de.governikus.csl.validation.x509.chain.TrustedAnchorDeterminator;
import de.governikus.csl.validation.x509.chain.ValidationStepCheckerParser;
import de.governikus.csl.validation.x509.chain.ValidityModelDeterminator;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCertChainValidator<CERT extends BaseCertificateSignature<?>, RESULT extends CertificateValidationResult>
implements CertChainValidator<CERT, RESULT> {
    protected final Logger log = LoggerFactory.getLogger(ParallelCertChainValidator.class);
    protected List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> customCriteria;
    protected List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> publicKeyCertCriteria;
    private ExecutorService executorService = null;
    private X509Plugin plugin;
    private AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> customPlugin;

    public ParallelCertChainValidator() {
    }

    public ParallelCertChainValidator(Configuration config) {
        this.plugin = new X509Plugin();
        this.plugin.configure(config);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> getCustomPlugin() {
        return this.customPlugin;
    }

    public void setCustomPlugin(AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> customPlugin) {
        this.customPlugin = customPlugin;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public CertChainResult<RESULT> validate(CERT signature, CertificateValidationContext context, List<TypedDate> potentialPOEs, List<TypedDate> potentialAlgValidationTimes) {
        Object certificate = ((BaseCertificateSignature)((Object)signature)).getCert();
        BigInteger serialNumber = certificate.getSerialNumber();
        this.log.debug("Validating certificate from issuer {} with serial {}", (Object)certificate.getIssuerX500Principal(), (Object)serialNumber);
        if (this.log.isTraceEnabled()) {
            try {
                byte[] encoded = certificate.getEncoded();
                String base64 = Base64.getEncoder().encodeToString(encoded);
                this.log.trace("{}={}", (Object)serialNumber, (Object)base64);
            }
            catch (Exception e) {
                this.log.error("Cannot log certificate {}: {}", (Object)serialNumber, (Object)e.getMessage());
            }
        }
        CertChainIterator<CERT> iterator = new CertChainIterator<CERT>(new CertChainItemGenerator((CertStore)context.getCertStore(), this.plugin));
        ValidationPolicyType policyFromRequest = context.getPolicy();
        Date referenceDate = ((BaseCertificateSignature)((Object)signature)).process(new ReferenceDateDeterminator(context, potentialPOEs));
        ((BaseCertificateSignature)((Object)signature)).process(new TrustStoreInformationRetriever(context.getTrustStore(), referenceDate));
        iterator.init(signature, referenceDate);
        RESULT chainResult = null;
        TypedDate bestPOE = null;
        TypedDate bestAlgValidationTime = null;
        PolicyProviderManager policyProviderManager = context.getConfiguration().getPolicyProviderManager();
        PolicyDeterminator determinator = new PolicyDeterminator(policyProviderManager);
        EvaluatedValidationPolicyType determinedPolicy = null;
        EvaluatedValidationPolicyType evaluatedPolicy = null;
        if (policyFromRequest != null) {
            evaluatedPolicy = PolicyEvaluator.createEvaluatedPolicy((ValidationPolicyType)policyFromRequest.cloneInstance(), (PolicyOrigin)PolicyOrigin.REQUEST, (boolean)true, (PolicyProviderManager)policyProviderManager);
        }
        while (iterator.hasNext()) {
            Object chain = iterator.next();
            if (this.checkQuality(context)) {
                this.inferCertQuality((CertChain<CERT>)chain, referenceDate);
                this.processTrustInformation((CertChain<CERT>)chain);
                this.inferTimestampQuality((CertChain<CERT>)chain);
            }
            if (evaluatedPolicy == null) {
                evaluatedPolicy = ((CertChain)chain).getEndEntityCertificate().process(determinator);
            } else if (determinedPolicy == null) {
                determinedPolicy = ((CertChain)chain).getEndEntityCertificate().process(determinator);
                PolicyNormalizer.normalizePolicy((ValidationPolicyType)evaluatedPolicy.getPolicy(), (ValidationPolicyType)determinedPolicy.getPolicy());
            }
            ValidationPolicyType policy = evaluatedPolicy.getPolicy();
            context.setPolicy(policy);
            RevocationValueValidationDepth revocationValueValidationDepth = policy.getRevocationValueValidationDepth();
            try {
                context.setRevocationValueValidationDepthChecker(ValidationStepCheckerParser.getInstance().getVersionChecker(revocationValueValidationDepth));
            }
            catch (IllegalArgumentException | ParseException e) {
                this.log.warn("Can't parse certificate validation depth pattern from policy", (Throwable)e);
            }
            SignedObjectType signedObjectTypeContext = context.getSignedObjectTypeContext();
            boolean certValidationInContextOfTstpOcspCrlSigner = SignedObjectType.TIMESTAMP.equals((Object)signedObjectTypeContext) || SignedObjectType.OCSP.equals((Object)signedObjectTypeContext) || SignedObjectType.CRL.equals((Object)signedObjectTypeContext);
            bestPOE = BestPOEDeterminator.getBestPOE(potentialPOEs, (ValidatePolicy)policy, certValidationInContextOfTstpOcspCrlSigner);
            bestAlgValidationTime = BestPOEDeterminator.getBestPOEForAlgorithmValidity(potentialAlgValidationTimes, (ValidatePolicy)policy);
            context.setBestSigningTime(bestPOE);
            context.setBestAlgValidationTime(bestAlgValidationTime);
            try {
                chainResult = this.validateChain((CertChain<CERT>)chain, context, potentialPOEs);
                if (chainResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR).getMajor() == MajorTotalResult.TOTAL_PASSED) {
                    break;
                }
            }
            catch (Exception e) {
                this.log.error("Can't validate certificate chain!", (Throwable)e);
            }
            if (!this.certNotFoundInTL(signature, chainResult)) continue;
            this.log.debug("Certificate not found in TLs");
            this.addSearchedTLs(signature, chainResult, context);
        }
        return new CertChainResult<Object>(chainResult, bestPOE, evaluatedPolicy);
    }

    private boolean checkQuality(CertificateValidationContext context) {
        return context.getSignedObjectTypeContext() != SignedObjectType.OCSP && context.getSignedObjectTypeContext() != SignedObjectType.CRL;
    }

    private boolean certNotFoundInTL(CERT signature, RESULT chainResult) {
        return signature instanceof X509Data && chainResult instanceof PublicKeyCertificateValidationResult && ((PublicKeyCertificateValidationResult)chainResult).getTSLInfo() == null;
    }

    private void addSearchedTLs(CERT signature, RESULT chainResult, CertificateValidationContext context) {
        X509Data x509Data = (X509Data)((Object)signature);
        TrustStore trustStore = context.getTrustStore();
        if (trustStore instanceof TLManager) {
            TLManager tlManager = (TLManager)trustStore;
            TLManagerEntry managedTrustedLists = tlManager.getManagedTrustedLists(((X509CertificateImpl)x509Data.getCert()).getSubjectX500Principal(), ((X509CertificateImpl)x509Data.getCert()).getIssuerX500Principal());
            if (managedTrustedLists == null) {
                return;
            }
            ArrayList<TLInfo> tlInfos = new ArrayList<TLInfo>();
            ArrayList<TLInfo> tlExtInfos = new ArrayList<TLInfo>();
            this.addTLInfos(() -> ((TLManagerEntry)managedTrustedLists).getOfficalTSL(), tlInfos, tlExtInfos);
            this.addTLInfos(() -> ((TLManagerEntry)managedTrustedLists).getGovernikusTSL(), tlInfos, tlExtInfos);
            this.addTLInfos(() -> ((TLManagerEntry)managedTrustedLists).getCustomTSL(), tlInfos, tlExtInfos);
            this.addLotlInfo(tlManager, tlInfos);
            PublicKeyCertificateValidationResult pubKeyRes = (PublicKeyCertificateValidationResult)chainResult;
            pubKeyRes.getCheckedTslInfos().addAll(tlInfos);
            pubKeyRes.getCheckedTslExtensionInfos().addAll(tlExtInfos);
        }
    }

    private void addTLInfos(Supplier<ManagedTL> tlGetter, List<TLInfo> tlInfoList, List<TLInfo> tlExtInfoList) {
        ManagedTL tl = tlGetter.get();
        if (tl != null) {
            TLInfo tlIdentifier = tl.getIdentifier();
            if (tlIdentifier != null) {
                tlInfoList.add(tlIdentifier);
            }
            tlExtInfoList.add(tl.getExtensionIdentifier());
        }
    }

    private void addLotlInfo(TLManager tlManager, List<TLInfo> tlInfos) {
        SecureTLManager secTlMgr;
        TLInfo lotlInfo;
        if (tlManager instanceof SecureTLManager && (lotlInfo = (secTlMgr = (SecureTLManager)tlManager).getLotlInfo()) != null) {
            tlInfos.add(lotlInfo);
        }
    }

    private void inferCertQuality(CertChain<CERT> chain, Date referenceDate) {
        new ETSIQualificationProcessor().process((BaseCertificateSignature<?>)((Object)chain.getEndEntityCertificate()), chain.getCACertificates(), referenceDate);
        DefaultQualityProcessor processor = DefaultQualityProcessor.builder().certificateQualityProcessor(DefaultCertificateQualityProcessor.newInstance()).signatureQualityProcessor(DefaultSignatureQualityProcessor.newInstance()).concernProcessor(DefaultConcernProcessor.newInstance()).build();
        processor.process((BaseCertificateSignature<?>)((Object)chain.getEndEntityCertificate()), chain.getCACertificates(), referenceDate);
    }

    private void inferTimestampQuality(CertChain<CERT> chain) {
        TimestampQualityDeterminator timestampQualityDeterminator = new TimestampQualityDeterminator();
        CERT endEntityCertificate = chain.getEndEntityCertificate();
        if (endEntityCertificate instanceof X509Data) {
            X509Data x509 = (X509Data)((Object)endEntityCertificate);
            timestampQualityDeterminator.determineQualityIfApplicable(x509);
        }
    }

    private void processTrustInformation(CertChain<CERT> chain) {
        Deque<X509Data> caCertificates = chain.getCACertificates();
        if (caCertificates != null && !caCertificates.isEmpty()) {
            Iterator<X509Data> iterator = caCertificates.iterator();
            X509Data last = iterator.next();
            while (iterator.hasNext()) {
                X509Data current = iterator.next();
                this.transferTSLInformation(last, current);
                last = current;
            }
            CERT endEntityCertificate = chain.getEndEntityCertificate();
            if (endEntityCertificate instanceof X509Data) {
                X509Data x509 = (X509Data)((Object)endEntityCertificate);
                this.transferTSLInformation(last, x509);
            } else if (endEntityCertificate instanceof AttributeCertificateSignature) {
                AttributeCertificateSignature acs = (AttributeCertificateSignature)((Object)endEntityCertificate);
                this.transferTSLInformation(last, acs);
            }
        }
    }

    private void transferTSLInformation(X509Data from, X509Data to) {
        if (to.getTslInformation() == null) {
            to.setTslInformation(from.getTslInformation());
        }
    }

    private void transferTSLInformation(X509Data from, AttributeCertificateSignature to) {
        if (to.getTslInformation() == null) {
            to.setTslInformation(from.getTslInformation());
        }
    }

    private RESULT validateChain(CertChain<CERT> certChain, CertificateValidationContext context, List<TypedDate> potentialPOEs) throws Exception {
        this.extendContextForRevocationTrustCheck(context, certChain);
        ArrayList<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>> caCalls = new ArrayList<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>>();
        int i = 1;
        CERT endEntityCertificate = certChain.getEndEntityCertificate();
        Deque<X509Data> caCertificates = certChain.getCACertificates();
        X509Data caCert = null;
        this.log.debug("{} CA certificates in chain", (Object)caCertificates.size());
        if (!caCertificates.isEmpty()) {
            caCert = caCertificates.getLast();
        }
        ValidityModelDeterminator validityModelDeterminator = new ValidityModelDeterminator((BaseCertificateSignature<?>)((Object)endEntityCertificate), caCertificates, (ValidatePolicy)context.getPolicy());
        ValidityModelDeterminationResult validityModel = ((BaseCertificateSignature)((Object)endEntityCertificate)).process(validityModelDeterminator);
        context.setPathValidationMethod(validityModel.getValidationMethod());
        TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> firstCall = this.createCallForFirst(i, caCertificates.isEmpty(), endEntityCertificate, validityModel, context, potentialPOEs);
        TrustedAnchorDeterminator det = new TrustedAnchorDeterminator(context.getPolicy().getTrustAnchorUsagePolicy());
        ((BaseCertificateSignature)((Object)endEntityCertificate)).process(det);
        IsCertificateSelfSignedOrTrustedAnchor chainEndReachedDecider = new IsCertificateSelfSignedOrTrustedAnchor();
        Object previous = endEntityCertificate;
        Iterator<X509Data> iterator = caCertificates.descendingIterator();
        while (iterator.hasNext()) {
            X509Data x509 = iterator.next();
            if (((BaseCertificateSignature)((Object)previous)).process(chainEndReachedDecider).booleanValue()) {
                this.log.debug("Chain end reached");
                break;
            }
            x509.process(det);
            if (x509.isTrustedAnchor()) {
                context.setTrustedAnchor(x509);
                ((CheckCertCall)firstCall.getDelegate()).getContext().setTrustedAnchor(x509);
                for (TraceContextTypedCallableDecorator traceContextTypedCallableDecorator : caCalls) {
                    ((CheckCertCall)traceContextTypedCallableDecorator.getDelegate()).getContext().setTrustedAnchor(x509);
                }
            }
            TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> cccDeco = this.createCall(++i, x509, (BaseCertificateSignature<?>)((Object)previous), validityModel, context);
            caCalls.add(cccDeco);
            previous.setSigningCertificate((X509CertificateImpl)x509.getCert());
            previous.setSigningCertificateTrustedAnchor(x509.isTrustedAnchor());
            previous = x509;
        }
        ((BaseCertificateSignature)((Object)previous)).setEndInChain(true);
        if (previous instanceof X509Data) {
            X509Data possibleRoot = (X509Data)((Object)previous);
            Object cert = possibleRoot.getCert();
            X500Principal x500Principal = cert.getIssuerX500Principal();
            X500Principal subject = cert.getSubjectX500Principal();
            if (subject.equals(x500Principal)) {
                possibleRoot.setSigningCertificate((X509CertificateImpl)possibleRoot.getCert());
                possibleRoot.setSelfSigned(true);
            }
        }
        RESULT first = null;
        int currentDepth = 0;
        CertChainValidationStep certChainValidationStep = context.getCertChainValidationDepth();
        if (certChainValidationStep != null) {
            currentDepth = certChainValidationStep.getCurrentDepth();
        }
        String principals = "[]";
        if (this.log.isTraceEnabled()) {
            principals = this.getX500Principals(firstCall, caCalls);
        }
        if (PathValidationMethod.COMBINED.equals((Object)context.getPathValidationMethod())) {
            this.log.trace("Entering sequential combined {} with {}", (Object)currentDepth, (Object)principals);
            first = this.executeSequentialCombined(context, validityModel, firstCall, caCalls);
            this.log.trace("Exiting sequential combined {} for {}", (Object)currentDepth, (Object)principals);
        } else if (this.executorService != null && currentDepth < 2) {
            this.log.trace("Entering parallel {} with {}", (Object)currentDepth, (Object)principals);
            first = this.executeParallel(firstCall, caCalls);
            this.log.trace("Exiting parallel {} for {}", (Object)currentDepth, (Object)principals);
        } else {
            this.log.trace("Entering sequential {} with {}", (Object)currentDepth, (Object)principals);
            first = this.executeSequential(firstCall, caCalls);
            this.log.trace("Exiting sequential {} for {}", (Object)currentDepth, (Object)principals);
        }
        return first;
    }

    private String getX500Principals(TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> firstCall, List<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>> caCalls) {
        X500Principal firstPrincipal = ((BaseCertificateSignature)((Object)((CheckCertCall)firstCall.getDelegate()).getCertificate())).getCert().getSubjectX500Principal();
        List caPrincipals = caCalls.stream().map(TraceContextDecorator::getDelegate).map(CheckCertCall::getCertificate).map(BaseCertificateSignature::getCert).map(CertificateBase::getSubjectX500Principal).collect(Collectors.toList());
        ArrayList<X500Principal> principals = new ArrayList<X500Principal>();
        principals.add(firstPrincipal);
        principals.addAll(caPrincipals);
        return principals.stream().map(X500Principal::toString).collect(Collectors.joining(" | ", "[", "]"));
    }

    private RESULT executeParallel(TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> firstCall, List<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>> caCalls) throws Exception {
        CertificateValidationResult first;
        ArrayList<Future> results = new ArrayList<Future>();
        for (TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> caCall : caCalls) {
            try {
                results.add(caCall.submit());
            }
            catch (RejectedExecutionException e) {
                this.log.info("Can't get thread from executor service. Perform validation in current thread");
                PublicKeyCertificateValidationResult res = (PublicKeyCertificateValidationResult)caCall.call();
                results.add(new FutureFacade(res));
            }
        }
        CertificateValidationResult current = first = (CertificateValidationResult)firstCall.call();
        for (Future future : results) {
            PublicKeyCertificateValidationResult x509ValidationResult = (PublicKeyCertificateValidationResult)future.get();
            current.setSigningCertificateValidationResult(x509ValidationResult);
            current = x509ValidationResult;
        }
        firstCall.restorePreviousSpan();
        return (RESULT)first;
    }

    private RESULT executeSequential(TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> firstCall, List<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>> caCalls) throws Exception {
        CertificateValidationResult first;
        CertificateValidationResult current = first = (CertificateValidationResult)firstCall.call();
        caCalls.forEach(caCall -> caCall.setKeepPrevSpan(true));
        for (TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> call : caCalls) {
            PublicKeyCertificateValidationResult x509ValidationResult = (PublicKeyCertificateValidationResult)call.call();
            current.setSigningCertificateValidationResult(x509ValidationResult);
            current = x509ValidationResult;
        }
        firstCall.restorePreviousSpan();
        return (RESULT)first;
    }

    private RESULT executeSequentialCombined(CertificateValidationContext context, ValidityModelDeterminationResult validityModel, TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> firstCall, List<TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>>> caCalls) throws Exception {
        CertificateValidationResult first;
        CertificateValidationResult current = first = (CertificateValidationResult)firstCall.call();
        TypedDate newBestSigningTime = null;
        caCalls.forEach(caCall -> caCall.setKeepPrevSpan(true));
        for (TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> call : caCalls) {
            PublicKeyCertificateValidationResult x509ValidationResult;
            if (newBestSigningTime != null) {
                ((CheckCertCall)call.getDelegate()).getContext().setBestSigningTime(newBestSigningTime);
            }
            if (this.doChainFallBack(x509ValidationResult = (PublicKeyCertificateValidationResult)call.call())) {
                TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> fallBackCallDeco = this.createCall(((CheckCertCall)call.getDelegate()).getContext().getCertChainValidationDepth().getCurrentDepth(), (X509Data)((Object)((CheckCertCall)call.getDelegate()).getCertificate()), ((X509Data)((Object)((CheckCertCall)call.getDelegate()).getCertificate())).getPrecursorInCertChain(), validityModel, context);
                CheckCertCall fallBackCall = (CheckCertCall)fallBackCallDeco.getDelegate();
                newBestSigningTime = ((X509Data)((Object)((CheckCertCall)call.getDelegate()).getCertificate())).getPrecursorInCertChain().getSigningTime();
                fallBackCall.getContext().setBestSigningTime(newBestSigningTime);
                fallBackCallDeco.setKeepPrevSpan(true);
                x509ValidationResult = (PublicKeyCertificateValidationResult)fallBackCallDeco.call();
            }
            current.setSigningCertificateValidationResult(x509ValidationResult);
            current = x509ValidationResult;
        }
        firstCall.restorePreviousSpan();
        return (RESULT)first;
    }

    private boolean doChainFallBack(PublicKeyCertificateValidationResult x509ValidationResult) {
        ValidationResult validityCheck = x509ValidationResult.getValidityCheck();
        boolean expired = false;
        if (validityCheck != null && MajorTotalResult.INDETERMINATE.equals((Object)validityCheck.getMajor()) && (MinorResult.OUT_OF_BOUNDS_NO_POE.equals((Object)validityCheck.getMinor()) || MinorResult.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)validityCheck.getMinor()))) {
            expired = true;
        }
        ValidationResult revocationStatusCheck = x509ValidationResult.getRevocationStatusCheck();
        CRLReason crlReason = x509ValidationResult.getRevocationReason();
        boolean revocationNotTotalPassed = false;
        boolean reasonIsKeyCompromise = false;
        if (revocationStatusCheck != null) {
            MajorTotalResult major = revocationStatusCheck.getMajor();
            boolean bl = revocationNotTotalPassed = !MajorTotalResult.TOTAL_PASSED.equals((Object)major) && !MajorTotalResult.NOT_VALIDATED.equals((Object)major);
            if (CRLReason.CA_COMPROMISE.equals((Object)crlReason) || CRLReason.KEY_COMPROMISE.equals((Object)crlReason)) {
                reasonIsKeyCompromise = true;
            }
        }
        return (expired || revocationNotTotalPassed) && !reasonIsKeyCompromise;
    }

    private void extendContextForRevocationTrustCheck(CertificateValidationContext context, CertChain<?> certChain) {
        Iterator<X509Data> iterator = certChain.getCACertificates().descendingIterator();
        while (iterator.hasNext()) {
            X509Data x509Data = iterator.next();
            if (x509Data.getServiceInformation() == null) continue;
            context.setRevocationTrustCheckAnchor(x509Data);
            break;
        }
    }

    private TraceContextTypedCallableDecorator<PublicKeyCertificateValidationResult, CheckCertCall<X509Data, PublicKeyCertificateValidationResult>> createCall(int i, X509Data x509, BaseCertificateSignature<?> previous, ValidityModelDeterminationResult validityModel, CertificateValidationContext context) {
        CertificateValidationContext clone = new CertificateValidationContext(context);
        clone.setPathValidationMethod(validityModel.getValidationMethod());
        CertChainValidationStep certChainValidationDepth = clone.getCertChainValidationDepth();
        if (previous instanceof X509Data) {
            x509.setPrecursorInCertChain((X509Data)previous);
        }
        certChainValidationDepth = certChainValidationDepth == null ? new CertChainValidationStep(i) : certChainValidationDepth.add(i);
        clone.setCertChainValidationDepth(certChainValidationDepth);
        if (PathValidationMethod.FORK.equals((Object)validityModel.getValidationMethod())) {
            clone.setBestSigningTime(previous.getSigningTime());
        }
        CheckCertCall<X509Data, PublicKeyCertificateValidationResult> checkCertCall = new CheckCertCall<X509Data, PublicKeyCertificateValidationResult>(x509, clone, this.publicKeyCertCriteria, this.plugin);
        return new TraceContextTypedCallableDecorator(this.executorService, checkCertCall);
    }

    private TraceContextTypedCallableDecorator<RESULT, CheckCertCall<CERT, RESULT>> createCallForFirst(int i, boolean last, CERT x509, ValidityModelDeterminationResult validityModel, CertificateValidationContext context, List<TypedDate> potentialPOEs) {
        TypedDate bestSigningTime;
        if (x509 instanceof X509Data) {
            ((X509Data)((Object)x509)).setPrecursorInCertChain(null);
        }
        ((BaseCertificateSignature)((Object)x509)).setValidityModel(validityModel);
        CertificateValidationContext clone = new CertificateValidationContext(context);
        clone.setPathValidationMethod(validityModel.getValidationMethod());
        CertChainValidationStep certChainValidationDepth = clone.getCertChainValidationDepth();
        certChainValidationDepth = certChainValidationDepth == null ? new CertChainValidationStep(i) : certChainValidationDepth.add(i);
        clone.setCertChainValidationDepth(certChainValidationDepth);
        if (validityModel.isEnforceUsageOfClaimedSigningTime() && (bestSigningTime = clone.getBestSigningTime()).getType() != DateType.CLAIMED_SIGNING_TIME) {
            for (TypedDate possiblePOE : potentialPOEs) {
                switch (possiblePOE.getType()) {
                    case CLAIMED_SIGNING_TIME: 
                    case SIGNATURE_TIME_MARK: {
                        clone.setBestSigningTime(possiblePOE);
                        break;
                    }
                }
            }
        }
        CheckCertCall<? super CERT, ? super RESULT> checkCertCall = new CheckCertCall<CERT, RESULT>(x509, clone, this.customCriteria, this.customPlugin);
        TraceContextTypedCallableDecorator checkCertCallDeco = new TraceContextTypedCallableDecorator(this.executorService, checkCertCall, true);
        return checkCertCallDeco;
    }

    public List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> getCustomCriteria() {
        return this.customCriteria;
    }

    public void setCustomCriteria(List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> customCriteria) {
        this.customCriteria = customCriteria;
    }

    public List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> getPublicKeyCertCriteria() {
        return this.publicKeyCertCriteria;
    }

    public void setPublicKeyCertCriteria(List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> publicKeyCertCriteria) {
        this.publicKeyCertCriteria = publicKeyCertCriteria;
    }

    @Override
    public void init(Configuration configuration, AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> customPlugin, List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> customCriteria, List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>> publicKeyCertCriteria) {
        this.plugin = new X509Plugin();
        this.plugin.configure(configuration);
        this.executorService = configuration.getExecutorService();
        this.customPlugin = customPlugin;
        this.customCriteria = customCriteria;
        this.publicKeyCertCriteria = publicKeyCertCriteria;
    }

    @Override
    public QualityProcessor<QualityResult> getQualityProcessor() {
        return DefaultQualityProcessor.builder().certificateQualityProcessor(DefaultCertificateQualityProcessor.newInstance()).signatureQualityProcessor(DefaultSignatureQualityProcessor.newInstance()).build();
    }
}

