/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.ValidityModelReason;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.Principal;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.X509Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class NonValidatingCertValidator
implements CertificateValidator {
    private ValidationPolicyType defaultPolicy;
    private PolicyProviderManager policyProviderManager;

    public NonValidatingCertValidator(PolicyProviderManager policyProviderManager) {
        this.defaultPolicy = policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG();
        this.policyProviderManager = policyProviderManager;
    }

    @Override
    public CertChainResult<PublicKeyCertificateValidationResult> validate(X509Data signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        return this.validate((X509CertificateImpl)signature.getCert(), possiblePOEs, context.getPolicy());
    }

    @Override
    public CertChainResult<AttributeCertificateValidationResult> validate(AttributeCertificateSignature signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        return this.validate((AttributeCertificate)((X509AttributeCertificateImpl)signature.getCert()).getWrappedCertificate(), possiblePOEs, context.getPolicy());
    }

    @Override
    public <S extends Signature, R extends SignatureValidationResult> void prefetchCertificateValidation(List<ValidationDocket<S, R>> validationDockets, ValidationPolicyType policyFromRequest, ValidationOptions options) {
        for (ValidationDocket<S, R> docket : validationDockets) {
            Set<AttributeCertificate> attributeCertificates;
            X509CertificateImpl signingCertificate = docket.getSigningCertificate();
            List<TypedDate> possiblePOEs = docket.getPossiblePOEs();
            if (signingCertificate != null) {
                CertChainResult<PublicKeyCertificateValidationResult> result = this.validate(signingCertificate, possiblePOEs, policyFromRequest);
                docket.setSigningCertificateValidationResult(result);
            }
            if ((attributeCertificates = docket.getAttributeCertificates()) == null) continue;
            ArrayList<CertChainResult<AttributeCertificateValidationResult>> attributeCertificateValidationResults = new ArrayList<CertChainResult<AttributeCertificateValidationResult>>();
            docket.setAttributeCertificateValidationResults(attributeCertificateValidationResults);
            for (AttributeCertificate ac : attributeCertificates) {
                CertChainResult<AttributeCertificateValidationResult> result = this.validate(ac, possiblePOEs, policyFromRequest);
                attributeCertificateValidationResults.add(result);
            }
        }
    }

    private CertChainResult<AttributeCertificateValidationResult> validate(AttributeCertificate attributeCertificate, List<TypedDate> possiblePOEs, ValidationPolicyType policyFromRequest) {
        ValidationPolicyType policy = policyFromRequest;
        PolicyOrigin po = PolicyOrigin.REQUEST;
        if (policy == null) {
            policy = this.defaultPolicy;
            po = PolicyOrigin.AUTOMATIC_DETERMINATION;
        }
        AttributeCertificateValidationResult result = new AttributeCertificateValidationResult();
        X509AttributeCertificateImpl signature = new X509AttributeCertificateImpl(attributeCertificate);
        result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"certificate_validation_disabled"));
        result.setCert(signature);
        result.setSubjectInfos(this.getAuthorityInfos(signature.getSubjectX500Principal()));
        result.setIssuerInfos(this.getAuthorityInfos(signature.getIssuerX500Principal()));
        result.setValidityModel(this.getValidityModel(policy));
        TypedDate bestPOE = BestPOEDeterminator.getBestPOE(possiblePOEs, (ValidatePolicy)policy);
        return new CertChainResult<AttributeCertificateValidationResult>(result, bestPOE, PolicyEvaluator.createEvaluatedPolicy((ValidationPolicyType)policy, (PolicyOrigin)po, (po == PolicyOrigin.REQUEST ? 1 : 0) != 0, (PolicyProviderManager)this.policyProviderManager));
    }

    private CertChainResult<PublicKeyCertificateValidationResult> validate(X509CertificateImpl signingCertificate, List<TypedDate> possiblePOEs, ValidationPolicyType policyFromRequest) {
        ValidationPolicyType policy = policyFromRequest;
        PolicyOrigin po = PolicyOrigin.REQUEST;
        if (policy == null) {
            policy = this.defaultPolicy;
            po = PolicyOrigin.AUTOMATIC_DETERMINATION;
        }
        PublicKeyCertificateValidationResult result = new PublicKeyCertificateValidationResult();
        result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"certificate_validation_disabled"));
        result.setCert(signingCertificate);
        result.setSubjectInfos(this.getAuthorityInfos(signingCertificate.getSubjectX500Principal()));
        result.setIssuerInfos(this.getAuthorityInfos(signingCertificate.getIssuerX500Principal()));
        result.setValidityModel(this.getValidityModel(policy));
        TypedDate bestPOE = BestPOEDeterminator.getBestPOE(possiblePOEs, (ValidatePolicy)policy);
        return new CertChainResult<PublicKeyCertificateValidationResult>(result, bestPOE, PolicyEvaluator.createEvaluatedPolicy((ValidationPolicyType)policy, (PolicyOrigin)po, (po == PolicyOrigin.REQUEST ? 1 : 0) != 0, (PolicyProviderManager)this.policyProviderManager));
    }

    private ValidityModelDeterminationResult getValidityModel(ValidationPolicyType policy) {
        PathValidationMethod pathValidationMethod = policy.getPathValidationMethod();
        return new ValidityModelDeterminationResult(pathValidationMethod, ValidityModelReason.POLICY);
    }

    private Principal getAuthorityInfos(X500Principal principal) {
        LDAPEntry entry = new LDAPEntry(principal);
        Principal p = new Principal();
        p.setCommonName(entry.getCommonName());
        p.setCountry(entry.getCountry());
        p.setOrganisation(entry.getOrganisation());
        return p;
    }
}

