/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.attributecert.AttributeCertificatePlugin;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.ContextUtil;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.ParallelCertChainValidator;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.X509Plugin;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCertValidator
implements CertificateValidator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected AttributeCertificatePlugin attributeCertificatePlugin;
    protected X509Plugin certificatePlugin;

    public LocalCertValidator() {
    }

    public LocalCertValidator(AttributeCertificatePlugin attributeCertificatePlugin, X509Plugin certificatePlugin) {
        this.attributeCertificatePlugin = attributeCertificatePlugin;
        this.certificatePlugin = certificatePlugin;
    }

    @Override
    public <S extends Signature, R extends SignatureValidationResult> void prefetchCertificateValidation(List<ValidationDocket<S, R>> validationDockets, ValidationPolicyType policyFromRequest, ValidationOptions options) {
        for (ValidationDocket<S, R> docket : validationDockets) {
            Set<AttributeCertificate> attributeCertificates;
            Object signature = docket.getSignature();
            X509CertificateImpl signingCertificate = docket.getSigningCertificate();
            List<TypedDate> possiblePOEs = docket.getPossiblePOEs();
            List<TypedDate> potentialAlgValidationTimes = docket.getPossibleAlgValidationTimes();
            List<TimestampValidationResult> possibleContentTimestampValidationResults = docket.getContentTimestampValidationResults();
            if (signingCertificate != null) {
                CertChainResult<PublicKeyCertificateValidationResult> result = this.validate(signingCertificate, (Signature)signature, possiblePOEs, potentialAlgValidationTimes, possibleContentTimestampValidationResults, policyFromRequest, options.getValidationDate(), options.getValidationData());
                docket.setSigningCertificateValidationResult(result);
            }
            if ((attributeCertificates = docket.getAttributeCertificates()) == null) continue;
            ArrayList<CertChainResult<AttributeCertificateValidationResult>> attributeCertificateValidationResults = new ArrayList<CertChainResult<AttributeCertificateValidationResult>>();
            docket.setAttributeCertificateValidationResults(attributeCertificateValidationResults);
            for (AttributeCertificate ac : attributeCertificates) {
                CertChainResult<AttributeCertificateValidationResult> result = this.validate(ac, (Signature)signature, possiblePOEs, potentialAlgValidationTimes, possibleContentTimestampValidationResults, policyFromRequest, options.getValidationDate(), options.getValidationData());
                attributeCertificateValidationResults.add(result);
            }
        }
    }

    private CertChainResult<AttributeCertificateValidationResult> validate(AttributeCertificate ac, Signature signature, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes, List<TimestampValidationResult> possibleContentTimestampValidationResults, ValidationPolicyType policyFromRequest, Date validationDate, ValidationData validationData) {
        AttributeCertificateSignature parseAsSignature = null;
        try {
            parseAsSignature = this.attributeCertificatePlugin.parseAsSignature(ac);
        }
        catch (ValidatePluginException e) {
            this.log.info("Can't parse attribute certificate", (Throwable)((Object)e));
            return null;
        }
        parseAsSignature.setBaseCertificate((X509CertificateFacade)signature.getSigningCertificate());
        CertificateValidationContext context = this.createContext(this.attributeCertificatePlugin, parseAsSignature, signature, possibleContentTimestampValidationResults, policyFromRequest, validationDate, validationData);
        return this.validate(parseAsSignature, context, possiblePOEs, potentialAlgValidationTimes);
    }

    @Override
    public CertChainResult<AttributeCertificateValidationResult> validate(AttributeCertificateSignature signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        ParallelCertChainValidator parallelCertChainValidator = new ParallelCertChainValidator();
        parallelCertChainValidator.init(context.getConfiguration(), this.attributeCertificatePlugin, this.attributeCertificatePlugin.getCustomSignatureValidationCriteria(), (List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>>)((List<ValidationCriterion<X509Data, PublicKeyCertificateValidationResult, CertificateValidationContext>>)X509Plugin.getAllKnownCustomPlugins()));
        return parallelCertChainValidator.validate((Object)((Object)signature), context, possiblePOEs, potentialAlgValidationTimes);
    }

    private CertChainResult<PublicKeyCertificateValidationResult> validate(X509CertificateImpl signingCertificate, Signature signature, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes, List<TimestampValidationResult> possibleContentTimestampValidationResults, ValidationPolicyType policyFromRequest, Date validationDate, ValidationData validationData) {
        X509Data parseAsSignature = null;
        try {
            parseAsSignature = this.certificatePlugin.parseAsSignature((X509Certificate)signingCertificate);
        }
        catch (ValidatePluginException e) {
            this.log.info("Can't parse certificate", (Throwable)((Object)e));
            return null;
        }
        parseAsSignature.setInformationSource(InformationSource.SIGNATURE);
        CertificateValidationContext context = this.createContext(this.certificatePlugin, parseAsSignature, signature, possibleContentTimestampValidationResults, policyFromRequest, validationDate, validationData);
        if (signature instanceof TimestampedObject) {
            TimestampedObject timestampedObject = (TimestampedObject)signature;
            parseAsSignature.setEuQC(timestampedObject.hasEUQCStatement());
        }
        return this.validate(parseAsSignature, context, possiblePOEs, potentialAlgValidationTimes);
    }

    @Override
    public CertChainResult<PublicKeyCertificateValidationResult> validate(X509Data signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        ParallelCertChainValidator parallelCertChainValidator = new ParallelCertChainValidator();
        parallelCertChainValidator.init(context.getConfiguration(), this.certificatePlugin, this.certificatePlugin.getCustomSignatureValidationCriteria(), (List<ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext>>)((List<ValidationCriterion<X509Data, PublicKeyCertificateValidationResult, CertificateValidationContext>>)this.certificatePlugin.getCustomSignatureValidationCriteria()));
        return parallelCertChainValidator.validate((Object)((Object)signature), context, possiblePOEs, potentialAlgValidationTimes);
    }

    private <T extends Signature> CertificateValidationContext createContext(AbstractDocumentPlugin<BaseObjectToValidate<T>, T, ?, ?, CertificateValidationContext> plugin, T certSignature, Signature signature, List<TimestampValidationResult> possibleContentTimestampValidationResults, ValidationPolicyType policyFromRequest, Date validationDate, ValidationData validationData) {
        CertificateValidationContext context = plugin.createContext(certSignature, policyFromRequest);
        context.setConfiguration(plugin.getConfiguration());
        context.extendContext(signature, validationDate, (ValidatePolicy)policyFromRequest);
        context.setSignedObjectTypeContext(signature.getType());
        ContextUtil.extendContextWithAttachedCertificates(signature, context);
        ContextUtil.extendContextWithAttachedRevocationValues(signature, context);
        ContextUtil.extendContextWithPrefetchedContentTimestampResults(context, possibleContentTimestampValidationResults);
        if (validationData != null) {
            ContextUtil.extendContextWithCertificates(context, validationData.getCertificates(), InformationSource.REQUEST);
            ContextUtil.extendContextWithRevocationValues(context, validationData.getOCSPValues(), validationData.getCRLs(), InformationSource.REQUEST);
        }
        return context;
    }
}

