/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.x509;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.SignatureValidatorImpl;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.criteria.CheckTrustStoreReliability;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CheckCertCall<CERT extends BaseCertificateSignature<?>, RESULT extends CertificateValidationResult>
implements Callable<RESULT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckCertCall.class);
    private CERT certificate;
    private AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> plugin;
    private CertificateValidationContext context;
    private List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> customCriteria;
    private String requestID;

    public CERT getCertificate() {
        return this.certificate;
    }

    public CertificateValidationContext getContext() {
        return this.context;
    }

    public CheckCertCall(CERT certToCheck, CertificateValidationContext context, List<ValidationCriterion<? super CERT, ? super RESULT, ? super CertificateValidationContext>> customCriteria2, AbstractDocumentPlugin<?, CERT, ?, RESULT, CertificateValidationContext> plugin) {
        this.certificate = certToCheck;
        this.context = context;
        this.customCriteria = customCriteria2;
        this.requestID = MDC.get((String)"requestID");
        this.plugin = plugin;
    }

    @Override
    public RESULT call() throws Exception {
        MDC.put((String)"requestID", (String)this.requestID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling cert check: {}", (Object)this.context.getCertChainValidationDepth().toString());
        }
        if (((BaseCertificateSignature)((Object)this.certificate)).isTrustedAnchor()) {
            CertificateValidationResult createSignatureResultStructure = (CertificateValidationResult)this.plugin.getResultInitializer().createSignatureResultStructure();
            TypedDate bestSigningTime = this.context.getBestSigningTime();
            if (bestSigningTime != null) {
                createSignatureResultStructure.setBestSignatureTime(bestSigningTime.getDate());
                createSignatureResultStructure.setBestSignatureTimeType(bestSigningTime.getType());
            }
            this.plugin.getSignatureDataExtractor().extractData(this.certificate, createSignatureResultStructure);
            createSignatureResultStructure.setCertChainCheck(this.getTLValidity());
            CheckTrustStoreReliability ctsr = new CheckTrustStoreReliability();
            ctsr.verify((BaseCertificateSignature<?>)((Object)this.certificate), createSignatureResultStructure, this.context);
            return (RESULT)createSignatureResultStructure;
        }
        SignatureValidatorImpl signatureValidatorImpl = new SignatureValidatorImpl(this.plugin, this.certificate, this.context);
        if (this.customCriteria != null) {
            signatureValidatorImpl.setCustomCriteria(this.customCriteria);
        }
        return (RESULT)((CertificateValidationResult)signatureValidatorImpl.validateSignature());
    }

    private ValidationResult getTLValidity() {
        ExtendedTLInformation tslInformation = ((BaseCertificateSignature)((Object)this.certificate)).getTslInformation();
        if (tslInformation != null) {
            TLInfo tslInfo = tslInformation.getTslInfo();
            Date nextUpdate = tslInfo.getNextUpdate();
            List reliabilityConcerns = tslInformation.getReliabilityConcerns();
            if (reliabilityConcerns != null && !reliabilityConcerns.isEmpty()) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (List)reliabilityConcerns);
            }
            if (nextUpdate != null && nextUpdate.compareTo(new Date()) < 0) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (String)"tl_expired");
            }
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, (String)"cert_as_trusted_anchor_by_tsl");
    }
}

