/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validation.x509.X509Data;
import java.util.EnumMap;
import org.apache.commons.lang3.tuple.Pair;

public class TimestampQualityDeterminator {
    private static final String TL_DE_COUNTRY_CODE = "DE";
    private static final EnumMap<TimestampQuality, String> QUALIFICATION_CODE_MAPPER = new EnumMap(TimestampQuality.class);

    public void determineQuality(X509Data cert, ServiceType serviceTypeIdentifier, ServiceStatus serviceStatus, ExtendedTLInformation extTlInfo) {
        String qualificationCode;
        TimestampQuality qualityToSet;
        TLType tlType = null;
        TLInfo tlInfo = null;
        String tlCountryCode = null;
        if (extTlInfo != null) {
            tlType = extTlInfo.getTslType();
            tlInfo = extTlInfo.getTslInfo();
            if (tlInfo != null) {
                tlCountryCode = tlInfo.getCountryCode();
            }
        }
        if (extTlInfo == null || tlType == null) {
            qualityToSet = TimestampQuality.DTST;
            qualificationCode = QUALIFICATION_CODE_MAPPER.get(qualityToSet);
        } else {
            switch (tlType) {
                case OFFICIAL: {
                    qualityToSet = this.processOfficialService(serviceTypeIdentifier, serviceStatus, tlCountryCode);
                    break;
                }
                case GOVERNIKUS: {
                    qualityToSet = this.processGovernikusService(serviceTypeIdentifier);
                    break;
                }
                case CUSTOM: {
                    qualityToSet = this.processCustomService(serviceTypeIdentifier);
                    break;
                }
                default: {
                    qualityToSet = TimestampQuality.DTST;
                }
            }
            qualificationCode = QUALIFICATION_CODE_MAPPER.get(qualityToSet);
        }
        cert.setTimestampQuality(qualityToSet);
        cert.setTimestampQualificationMsgCode(SVPFactory.createMessageCode((String)qualificationCode));
    }

    private TimestampQuality processCustomService(ServiceType serviceTypeIdentifier) {
        TimestampQuality timestampQualityToSet = serviceTypeIdentifier == ServiceType.TSA ? TimestampQuality.TSA_CUSTOM_TL : (serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES ? TimestampQuality.TSA_TSS_AdES_QC_AND_QES_CUSTOM_TL : (serviceTypeIdentifier == ServiceType.TSS_QC ? TimestampQuality.TSA_TSS_QC_CUSTOM_TL : TimestampQuality.DTST));
        return timestampQualityToSet;
    }

    private TimestampQuality processGovernikusService(ServiceType serviceTypeIdentifier) {
        TimestampQuality timestampQualityToSet = serviceTypeIdentifier == ServiceType.TSA ? TimestampQuality.TSA_GOV_TL : (serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES ? TimestampQuality.TSA_TSS_AdES_QC_AND_QES_GOV_TL : (serviceTypeIdentifier == ServiceType.TSS_QC ? TimestampQuality.TSA_TSS_QC_GOV_TL : TimestampQuality.DTST));
        return timestampQualityToSet;
    }

    private TimestampQuality processOfficialService(ServiceType serviceTypeIdentifier, ServiceStatus serviceStatus, String tlCountryCode) {
        TimestampQuality timestampQualityToSet = null;
        if (serviceTypeIdentifier == ServiceType.QTST) {
            if (serviceStatus == ServiceStatus.GRANTED) {
                timestampQualityToSet = TimestampQuality.QTST_EUMS_TL;
            } else {
                timestampQualityToSet = this.checkGermanSignatureLawTimestamp(serviceStatus, tlCountryCode);
                if (timestampQualityToSet == null) {
                    timestampQualityToSet = TimestampQuality.NO_QTST_EUMS_TL;
                }
            }
        } else {
            timestampQualityToSet = serviceTypeIdentifier == ServiceType.TSA ? (serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL ? TimestampQuality.TSA_EUMS_TL : TimestampQuality.NO_TSA_EUMS_TL) : (serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES ? (serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL ? TimestampQuality.TSA_TSS_AdES_QC_AND_QES_EUMS_TL : TimestampQuality.NO_TSA_TSS_AdES_QC_AND_QES_EUMS_TL) : (serviceTypeIdentifier == ServiceType.TSS_QC ? (serviceStatus == ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL ? TimestampQuality.TSA_TSS_QC_EUMS_TL : TimestampQuality.NO_TSA_TSS_QC_EUMS_TL) : TimestampQuality.DTST));
        }
        return timestampQualityToSet;
    }

    private TimestampQuality checkGermanSignatureLawTimestamp(ServiceStatus serviceStatus, String tlCountryCode) {
        TimestampQuality qualityToSet = null;
        if (TL_DE_COUNTRY_CODE.equalsIgnoreCase(tlCountryCode)) {
            qualityToSet = serviceStatus == ServiceStatus.ACCREDITED || serviceStatus == ServiceStatus.UNDER_SUPERVISION || serviceStatus == ServiceStatus.SUPERVISION_IN_CESSATION ? TimestampQuality.QTST_SIGG_EUMS_TL : TimestampQuality.NO_QTST_SIGG_EUMS_TL;
        }
        return qualityToSet;
    }

    public void determineQualityIfApplicable(X509Data cert) {
        Pair<ServiceInformation, ExtendedTLInformation> serviceInfoPair = this.getServiceInfo(cert);
        ServiceInformation serviceInfo = (ServiceInformation)serviceInfoPair.getLeft();
        if (serviceInfo == null) {
            return;
        }
        ServiceType serviceTypeIdentifier = serviceInfo.getServiceTypeIdentifier();
        ServiceStatus serviceStatus = serviceInfo.getServiceStatus();
        if (serviceTypeIdentifier == null || serviceStatus == null) {
            return;
        }
        if (serviceTypeIdentifier == ServiceType.QTST || serviceTypeIdentifier == ServiceType.TSA || serviceTypeIdentifier == ServiceType.TSS_AdESQCandQES || serviceTypeIdentifier == ServiceType.TSS_QC) {
            this.determineQuality(cert, serviceTypeIdentifier, serviceStatus, (ExtendedTLInformation)serviceInfoPair.getRight());
        }
    }

    private Pair<ServiceInformation, ExtendedTLInformation> getServiceInfo(X509Data cert) {
        ServiceInformation serviceInformation = cert.getServiceInformation();
        ExtendedTLInformation extTlInfo = cert.getTslInformation();
        if (serviceInformation == null) {
            serviceInformation = cert.getIssuerServiceInformation();
        }
        return Pair.of((Object)serviceInformation, (Object)extTlInfo);
    }

    static {
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.DTST, "quality_check_NO_SDI_all_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.NO_QTST_EUMS_TL, "quality_service_status_not_granted_qtst");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.NO_TSA_EUMS_TL, "quality_service_status_not_granted_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.NO_TSA_TSS_AdES_QC_AND_QES_EUMS_TL, "quality_service_status_not_granted_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.NO_TSA_TSS_QC_EUMS_TL, "quality_service_status_not_granted_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.QTST_EUMS_TL, "quality_check_QTST_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_CUSTOM_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_CUSTOM_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_EUMS_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_GOV_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_GOV_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_AdES_QC_AND_QES_CUSTOM_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_CUSTOM_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_AdES_QC_AND_QES_EUMS_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_AdES_QC_AND_QES_GOV_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_GOV_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_QC_CUSTOM_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_CUSTOM_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_QC_EUMS_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_EUMS_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.TSA_TSS_QC_GOV_TL, "quality_check_TSA_TSS_QC_TSS_AdES_QC_AND_QES_GOV_TL");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.NO_QTST_SIGG_EUMS_TL, "quality_service_status_not_granted_qtst_sigg");
        QUALIFICATION_CODE_MAPPER.put(TimestampQuality.QTST_SIGG_EUMS_TL, "quality_check_QTST_SIGG_EUMS_TL");
    }
}

