/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckSigningCertificateReferences;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.tsp.ExtendedKeyUsageCheckTSP;
import de.governikus.csl.validation.tsp.MessageImprintAlgorithmCheck;
import de.governikus.csl.validation.tsp.MessageImprintCheck;
import de.governikus.csl.validation.tsp.TSPDataExtractor;
import de.governikus.csl.validation.tsp.TSPParser;
import java.util.ArrayList;
import java.util.List;

@PluginType(id=Plugin.PluginID.VALIDATE_TSP, type=ValidatePlugin.class)
public class TSPPlugin
extends AbstractDocumentPlugin<BaseObjectToValidate<Timestamp>, Timestamp, ObjectValidationResult, TimestampValidationResult, SignatureValidationContext> {
    public TSPPlugin() {
        super(Timestamp.class, SignatureValidationContext.class);
    }

    @Override
    public BaseObjectToValidate<Timestamp> parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        TSPParser parser = new TSPParser(this.configuration.getAlgorithmManager());
        try {
            return parser.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException(this, "Can't parse document", e);
        }
    }

    @Override
    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        return SVPFactory.createObjectValidationResult((String)this.getID());
    }

    @Override
    protected TimestampValidationResult createSignatureValidationResultStructure() {
        return new TimestampValidationResult();
    }

    @Override
    public DataExtractor<? super Timestamp, ? super TimestampValidationResult> getSignatureDataExtractor() {
        return new TSPDataExtractor();
    }

    @Override
    public SignatureValidationContext createContext(Timestamp signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public static List<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> result = new ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>>();
        result.add(new MessageImprintAlgorithmCheck());
        result.add(new MessageImprintCheck());
        result.add(new ExtendedKeyUsageCheckTSP());
        result.add(new CheckSigningCertificateReferences());
        return result;
    }
}

