/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.SSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamableInputData;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.CertificateSet;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignerIdentifier;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.UnsignedAttributes;
import de.bos_bremen.ci.asn1.tsp.Accuracy;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.tsp.SigningCertificate;
import de.bos_bremen.ci.asn1.tsp.TSTInfo;
import de.bos_bremen.ci.asn1.tsp.TimeStampResp;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.QCStatement;
import de.bos_bremen.ci.asn1.x509.ext.QCStatementsExtension;
import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.impl.FileStreamProvider;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.ConcatenatedDocumentInputStreamProvider;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.WritableSignature;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.ASN1Util;
import de.governikus.csl.validation.tsp.DefaultTimestampFactory;
import de.governikus.csl.validation.tsp.TimestampFactory;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.governikus.csl.vi.StreamableCSLDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSPParser
extends AbstractDocumentParser<BaseObjectToValidate<Timestamp>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSPParser.class);
    private static final int SEC_TO_MICROSEC_FACTOR = 1000000;
    private static final int MILLISEC_TO_MICROSEC_FACTOR = 1000;
    private AlgorithmManager algorithmManager;

    public TSPParser(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
    }

    public BaseObjectToValidate<Timestamp> loadDocument(SignedData sda) throws Exception {
        Document d = sda.getSignature();
        SSource sSource = new SSource((StreamableInputData)new StreamableCSLDocument(d));
        de.bos_bremen.ci.asn1.cms.SignedData signedData = null;
        try {
            SignatureTimeStampToken stst = new SignatureTimeStampToken((Source)sSource);
            signedData = stst.getSignedData();
            if (signedData == null) {
                throw new ParseException("The data does not seem to be a timestamp");
            }
        }
        catch (ParseException e) {
            TimeStampResp tsr = new TimeStampResp((Source)sSource);
            signedData = (de.bos_bremen.ci.asn1.cms.SignedData)tsr.getTimeStampToken().getContent();
        }
        BaseObjectToValidate result = new BaseObjectToValidate();
        List<TimestampedObject> timestamp = this.parse(signedData, sda);
        if (timestamp == null) {
            throw new ParseException("The data does not seem to be a timestamp");
        }
        result.setSignatures(timestamp);
        result.setName(d.getName());
        return result;
    }

    public <T extends WritableTimestamp<S>, S extends WritableSignature> List<T> parse(de.bos_bremen.ci.asn1.cms.SignedData signedData, SignedData sda, TimestampFactory<T, S> factory) {
        EncapsulatedContentInfo contentInfo = signedData.getEncapsulatedContentInfo();
        if (!ContentType.id_ct_TSTInfo.equals((Object)contentInfo.getContentType())) {
            LOGGER.warn("Could not parse timestamps. Wrong content type.");
            return null;
        }
        CertificateSet certSet = signedData.getCertificates();
        TSTInfo tstInfo = (TSTInfo)contentInfo.getContent();
        Long accuracy = this.extractAccuracy(tstInfo);
        BOOLEAN order = tstInfo.getOrdering();
        Boolean ordering = null;
        if (order != null) {
            ordering = order.getValue();
        }
        Map<FlatCertificate, X509Certificate> attachedCertificates = this.extractCertificates(certSet);
        boolean hasEUQCompliance = this.extractEuQCompliance(tstInfo);
        INTEGER serialNumber = tstInfo.getSerialNumber();
        BigInteger serial = null;
        if (serialNumber != null) {
            serial = serialNumber.getValue();
        }
        List signerInfos = signedData.getSignerInfoList();
        ArrayList<T> timestamps = new ArrayList<T>();
        for (SignerInfo signerInfo : signerInfos) {
            Date date;
            T timestamp = factory.createNewTimestamp();
            timestamp.setType(SignedObjectType.TIMESTAMP);
            timestamp.setMessageImprint(tstInfo.getMessageImprint().getHashedMessage().getOctets());
            AlgorithmIdentifier s = tstInfo.getMessageImprint().getHashAlgorithm();
            DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByJcaOidOrUrl(s.getJCAName(), s.getOID().getOID(), null);
            timestamp.setMessageImprintHashAlgorithm(digestAlgorithm);
            timestamp.setAccuracy(accuracy);
            timestamp.setOrdering(ordering);
            timestamp.setEUQCStatement(hasEUQCompliance);
            timestamp.setSerial(serial);
            timestamp.setSignatureValue(signerInfo.getSignature().getOctets());
            this.setCertsOnTimestamp(timestamp, signerInfo, attachedCertificates);
            UnsignedAttributes unsignedAttributes = signerInfo.getUnsignedAttributes();
            if (unsignedAttributes != null) {
                timestamp.setAtsHashIndizes(this.processAtsHashIndexAttribute(unsignedAttributes));
            }
            if ((date = tstInfo.getGenTime().getDate()) != null) {
                timestamp.setGenerationTime(date);
                timestamp.setSigningTime(SVPFactory.createTypedDate((Date)date, (DateType)DateType.CLAIMED_SIGNING_TIME));
            }
            this.setAlgoSigCertRefAndContent(timestamp, signerInfo, contentInfo, sda);
            timestamps.add(timestamp);
        }
        return timestamps;
    }

    private Map<FlatCertificate, X509Certificate> extractCertificates(CertificateSet certSet) {
        List certs;
        HashMap<FlatCertificate, X509Certificate> attachedCertificates = new HashMap<FlatCertificate, X509Certificate>();
        if (certSet != null && (certs = certSet.getCertificateChoices()) != null) {
            for (FlatCertificate flatCert : certs) {
                try {
                    CertificateFactory certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
                    X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(flatCert.getEncoded()));
                    if (cert == null) continue;
                    attachedCertificates.put(flatCert, cert);
                }
                catch (NoSuchProviderException | CertificateException e) {
                    LOGGER.warn("Error while processing certificate.", (Throwable)e);
                }
            }
        }
        return attachedCertificates;
    }

    private boolean extractEuQCompliance(TSTInfo tstInfo) {
        Extension qcTypeExtension;
        Extensions extensions = tstInfo.getExtensions();
        boolean hasEUQCompliance = false;
        if (extensions != null && (qcTypeExtension = extensions.get("1.3.6.1.5.5.7.1.3")) != null) {
            QCStatementsExtension qxExt = (QCStatementsExtension)qcTypeExtension;
            List qcStatements = qxExt.getQCStatements();
            for (QCStatement qcs : qcStatements) {
                String oid = qcs.getOID().getOID();
                if (!oid.equals("0.4.0.19422.1.1")) continue;
                hasEUQCompliance = true;
                break;
            }
        }
        return hasEUQCompliance;
    }

    private Long extractAccuracy(TSTInfo tstInfo) {
        Accuracy accuracy = tstInfo.getAccuracy();
        if (accuracy != null) {
            BigInteger value = BigInteger.ZERO;
            INTEGER seconds = accuracy.getSeconds();
            INTEGER milliseconds = accuracy.getMillis();
            INTEGER microseconds = accuracy.getMicros();
            if (seconds != null) {
                value = seconds.getValue().multiply(BigInteger.valueOf(1000000L));
            }
            if (milliseconds != null) {
                value = value.add(milliseconds.getValue().multiply(BigInteger.valueOf(1000L)));
            }
            if (microseconds != null) {
                value = value.add(microseconds.getValue());
            }
            return value.longValue();
        }
        return null;
    }

    private <T extends WritableTimestamp<S>, S extends WritableSignature> void setCertsOnTimestamp(T timestamp, SignerInfo signerInfo, Map<FlatCertificate, X509Certificate> attachedCertificates) {
        if (!attachedCertificates.isEmpty()) {
            HashSet<SignatureValidationDataAttachmentImpl> certs = new HashSet<SignatureValidationDataAttachmentImpl>();
            SignerIdentifier sinfo = signerInfo.getSignerIdentifier();
            for (Map.Entry<FlatCertificate, X509Certificate> certMapEntry : attachedCertificates.entrySet()) {
                if (sinfo.matches(certMapEntry.getKey())) {
                    timestamp.setSigningCertificate(new X509CertificateImpl(certMapEntry.getValue()));
                    continue;
                }
                certs.add(new SignatureValidationDataAttachmentImpl((Object)certMapEntry.getValue()));
            }
            if (!certs.isEmpty()) {
                timestamp.setAttachedCertificates(certs);
            }
        }
    }

    private <T extends WritableTimestamp<S>, S extends WritableSignature> void setAlgoSigCertRefAndContent(T timestamp, SignerInfo signerInfo, EncapsulatedContentInfo contentInfo, SignedData sda) {
        try {
            AlgorithmIdentifier siAlg = signerInfo.getSignatureAlgorithm();
            SignatureAlgorithm signatureAlgorithm = this.algorithmManager.getSignatureAlgorithmByJcaOidOrUrl(siAlg.getJCAName(), siAlg.getOID().getOID(), null);
            timestamp.setSignatureAlgorithm(signatureAlgorithm);
            SignedAttributes signedAttributes = signerInfo.getSignedAttributes();
            SigningCertificate signingCertificateAttribute = (SigningCertificate)signedAttributes.getValue(SignedAttribute.SIGNING_CERTIFICATE_V2);
            if (signingCertificateAttribute == null) {
                signingCertificateAttribute = (SigningCertificate)signedAttributes.getValue(SignedAttribute.signingCertificate);
            }
            timestamp.setSigningCertificateReferences(ASN1Util.createCertificateReferences(signingCertificateAttribute, this.algorithmManager));
            byte[] bytes = signedAttributes.asByteArray();
            if (bytes.length > 0 && signedAttributes.isImplicit()) {
                bytes[0] = 49;
            }
            timestamp.setSignedContent((Document)new ByteArrayDocument(bytes));
            timestamp.setSignedContentParts(this.getSignedContentParts(signerInfo, contentInfo, sda));
        }
        catch (ParseException | NoSuchAlgorithmException e) {
            LOGGER.warn("Can't set signed content.", e);
        }
        if (sda != null) {
            List contents = sda.getContents();
            List timestampedContentHashes = sda.getHashValues();
            if (contents != null && !contents.isEmpty()) {
                timestamp.setTimestampedContent((StreamProvider)contents.get(0));
            } else if (timestampedContentHashes != null && !timestampedContentHashes.isEmpty()) {
                timestamp.setTimestampedContentHash((byte[])timestampedContentHashes.get(0));
            }
        }
    }

    private List<AtsHashIndex> processAtsHashIndexAttribute(UnsignedAttributes unsignedAttributes) {
        List<AtsHashIndex> result = null;
        List values = unsignedAttributes.getValues(Attribute.ATS_HASH_INDEX_V1);
        result = this.processAtsHashIndexAttribute(values, result);
        values = unsignedAttributes.getValues(Attribute.ATS_HASH_INDEX_V2);
        result = this.processAtsHashIndexAttribute(values, result);
        values = unsignedAttributes.getValues(Attribute.ATS_HASH_INDEX_V3);
        result = this.processAtsHashIndexAttribute(values, result);
        return result;
    }

    private List<AtsHashIndex> processAtsHashIndexAttribute(List<ANY> values, List<AtsHashIndex> currentValues) {
        if (values == null || values.isEmpty()) {
            return currentValues;
        }
        if (currentValues == null) {
            currentValues = new ArrayList<AtsHashIndex>();
        }
        List<AtsHashIndex> data = currentValues;
        values.forEach(x -> data.add((AtsHashIndex)x));
        return data;
    }

    public List<TimestampedObject> parse(de.bos_bremen.ci.asn1.cms.SignedData signedData, SignedData sda) {
        return this.parse(signedData, sda, new DefaultTimestampFactory());
    }

    private List<? extends SignedContentPart> getSignedContentParts(SignerInfo si, EncapsulatedContentInfo contentInfo, SignedData sda) {
        SignedAttributes sa = si.getSignedAttributes();
        if (sa != null) {
            OCTETSTRING digestString = (OCTETSTRING)sa.getValue(SignedAttribute.messageDigest);
            byte[] digest = digestString.getOctets();
            byte[] data = null;
            FileStreamProvider contentData = null;
            ANY content = contentInfo.getContent();
            if (content instanceof OCTETSTRING) {
                OCTETSTRING os = (OCTETSTRING)content;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    os.writeContent((OutputStream)baos);
                    baos.close();
                    data = baos.toByteArray();
                }
                catch (IOException e) {
                    LOGGER.warn("Error while reading content data.", (Throwable)e);
                }
                contentData = new ByteArrayStreamProvider(data);
            } else if (content instanceof TSTInfo) {
                TSTInfo info = (TSTInfo)content;
                byte[] imprint = info.asByteArray();
                contentData = new ByteArrayStreamProvider(imprint);
            } else if (contentInfo.getLinkedContent() != null) {
                contentData = new FileStreamProvider(contentInfo.getLinkedContent());
            } else if (content == null && sda != null && sda.getContents() != null) {
                List signedContent = sda.getContents();
                contentData = new ConcatenatedDocumentInputStreamProvider(signedContent);
            } else {
                data = contentInfo.getValueAsByteArray();
                contentData = new ByteArrayStreamProvider(data);
            }
            DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByOID(si.getDigestAlgorithm().getOID().getOID());
            BaseSignedContentPart result = new BaseSignedContentPart((StreamProvider)contentData, digest, digestAlgorithm);
            return Collections.singletonList(result);
        }
        return null;
    }
}

