/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.dataExtractor.DefaultContentSignatureDataExtractor;
import javax.xml.bind.DatatypeConverter;

public class TSPDataExtractor
extends DefaultContentSignatureDataExtractor<Timestamp, TimestampValidationResult> {
    @Override
    public void extractData(Timestamp source, TimestampValidationResult destination) {
        super.extractData(source, destination);
        destination.setGenerationTime(source.getGenerationTime());
        StreamProvider timestampedContent = source.getTimestampedContent();
        byte[] timestampedContentHash = source.getTimestampedContentHash();
        if (timestampedContent instanceof Document) {
            String name = ((Document)timestampedContent).getName();
            destination.getContentNames().add(name);
        } else if (timestampedContentHash != null) {
            String hexBinary = DatatypeConverter.printHexBinary((byte[])timestampedContentHash);
            destination.getContentNames().add(hexBinary);
        }
        destination.setSerial(source.getSerial());
        destination.setEuQcStatement(Boolean.valueOf(source.hasEUQCStatement()));
        DigestAlgorithm messageImprintHashAlgorithm = source.getMessageImprintHashAlgorithm();
        destination.setMessageImprintHashAlgorithm(SVPFactory.createDigestAlgorithm((DigestAlgorithm)messageImprintHashAlgorithm));
        TimestampQuality timestampQuality = null;
        ValidationMessageCode timestampQualityCode = null;
        for (PublicKeyCertificateValidationResult signingCertificateValidationResult = destination.getSigningCertificateValidationResult(); (timestampQuality == null || timestampQualityCode == null) && signingCertificateValidationResult != null; signingCertificateValidationResult = signingCertificateValidationResult.getSigningCertificateValidationResult()) {
            timestampQuality = signingCertificateValidationResult.getTimestampQuality();
            timestampQualityCode = signingCertificateValidationResult.getTimestampQualificationMsgCode();
            if (timestampQuality == null || timestampQualityCode == null) continue;
            destination.setTimestampQuality(timestampQuality);
            destination.setTimestampQualificationMsgCode(timestampQualityCode);
            signingCertificateValidationResult.setTimestampQuality(null);
            signingCertificateValidationResult.setTimestampQualificationMsgCode(null);
            return;
        }
    }
}

