/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageImprintCheck
extends AbstractValidationCriterion<Timestamp, TimestampValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageImprintCheck.class);

    @Override
    public void verify(Timestamp timestamp, TimestampValidationResult result, SignatureValidationContext context) {
        StreamProvider timestampedContent = timestamp.getTimestampedContent();
        byte[] timestampedContentHash = timestamp.getTimestampedContentHash();
        if (timestampedContent == null && timestampedContentHash == null) {
            MessageImprintCheck.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIGNED_DATA_NOT_FOUND, (String[])new String[]{"detached_content_file_missing"}));
            return;
        }
        byte[] hashToCompare = null;
        if (timestampedContent != null) {
            DigestAlgorithm algorithm = timestamp.getMessageImprintHashAlgorithm();
            try {
                MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)algorithm.getJCAName());
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int read = 0;
                try (InputStream is = timestampedContent.getInputStream();){
                    while ((read = is.read(buffer)) > 0) {
                        md.update(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    LOGGER.info("Failed to read timestamped content", (Throwable)e);
                }
                hashToCompare = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.warn("Unsupported digest algorithm", (Throwable)e);
            }
            catch (NoSuchProviderException e1) {
                LOGGER.error("Can't find crypto provider with Name {}", (Object)CryptoProviderUtil.PROVIDER);
            }
        } else {
            hashToCompare = timestampedContentHash;
        }
        ValidationResult val = MessageDigest.isEqual(hashToCompare, timestamp.getMessageImprint()) ? SVPFactory.createResultOk() : SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE);
        MessageImprintCheck.setResult(result, val);
    }

    private static void setResult(TimestampValidationResult result, ValidationResult validationResultImpl) {
        result.setImprintCheck(validationResultImpl);
    }
}

