/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.Date;
import java.util.List;

public class MessageImprintAlgorithmCheck
extends AbstractValidationCriterion<Timestamp, TimestampValidationResult, SignatureValidationContext> {
    @Override
    public void verify(Timestamp timestamp, TimestampValidationResult result, SignatureValidationContext context) {
        DigestAlgorithm messageImprintHashAlgorithm = timestamp.getMessageImprintHashAlgorithm();
        if (timestamp.getSigningCertificate() == null) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND));
            return;
        }
        ValidationPolicyType policy = context.getPolicy();
        String catalogName = policy.getAlgorithmCatalog().name();
        AlgorithmCatalogManager algorithmCatalogManager = context.getConfiguration().getAlgorithmCatalog();
        AlgorithmCatalog algorithmCatalog = null;
        try {
            algorithmCatalog = algorithmCatalogManager.getAlgorithmCatalog(catalogName);
        }
        catch (UnsupportedCatalogNameException e) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"}));
            return;
        }
        AlgorithmCatalogMetaInformation catalogMetaData = algorithmCatalog.getCatalogMetaData();
        List reliabilityConcerns = catalogMetaData.getReliabilityConcerns();
        if (reliabilityConcerns != null && !reliabilityConcerns.isEmpty()) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (List)reliabilityConcerns));
            return;
        }
        AlgorithmCatalogResponse resp = null;
        try {
            resp = algorithmCatalogManager.getAlgorithmValidity(catalogName, messageImprintHashAlgorithm, Usage.VERIFY_TIMESTAMP_SIGNATURE);
        }
        catch (UnsupportedCatalogNameException e) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"}));
            return;
        }
        catch (IllegalArgumentException e) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"illegal_argument_message_imprint_algorithm_check"}));
            return;
        }
        if (resp.getExpirationDate() == null && !resp.isWithoutExpirationDate()) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_algorithm_not_in_catalog"}));
            return;
        }
        Date dateToCheck = context.getBestSigningTime().getDate();
        ValidationResult vr = null;
        vr = resp.isWithoutExpirationDate() || dateToCheck != null && resp.getExpirationDate().compareTo(dateToCheck) >= 0 ? SVPFactory.createResultOk() : SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE_NO_POE);
        result.setMessageImprintAlgorithmCheck(vr);
    }

    @Override
    public boolean isApplicable(Timestamp signature, TimestampValidationResult result, SignatureValidationContext context) {
        ValidationPolicyType policy = context.getPolicy();
        boolean applicable = policy.isAlgorithmValidityCheckAtBestPOERequired();
        if (!applicable) {
            result.setMessageImprintAlgorithmCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
        }
        return applicable;
    }
}

