/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.tsp;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.security.cert.CertificateParsingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedKeyUsageCheckTSP
extends AbstractValidationCriterion<Timestamp, TimestampValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedKeyUsageCheckTSP.class);

    @Override
    public void verify(Timestamp signature, TimestampValidationResult result, SignatureValidationContext context) {
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        if (signingCertificate == null) {
            result.setExtendedKeyUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND));
            return;
        }
        try {
            List extendedKeyUsage = signingCertificate.getExtendedKeyUsage();
            if (extendedKeyUsage == null || extendedKeyUsage.isEmpty()) {
                result.setExtendedKeyUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tsp_no_extendend_keyusage_in_cert"}));
                return;
            }
            if (extendedKeyUsage.size() > 1) {
                result.setExtendedKeyUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tsp_multiple_extendend_keyusage_in_cert"}));
                return;
            }
            String keyUsageOID = (String)extendedKeyUsage.get(0);
            if (!keyUsageOID.equals("1.3.6.1.5.5.7.3.8")) {
                result.setExtendedKeyUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tsp_wrong_extendend_keyusage_in_cert"}));
                return;
            }
            result.setExtendedKeyUsageCheck(SVPFactory.createResultOk());
        }
        catch (CertificateParsingException e) {
            LogHelper.logException((String)"Can't parse extended key usage", (Logger)LOGGER, (Throwable)e);
            result.setExtendedKeyUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"tsp_key_usage_not_parsable"}));
        }
    }
}

