/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.context.ContextUtil;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.chain.PolicyDeterminator;
import java.util.List;
import java.util.Optional;

public class PrefetchingSignatureValidatorUtil {
    private DocumentValidationContext documentValidationContext;
    private Configuration config;
    private ValidationPolicyType policyFromRequest;

    PrefetchingSignatureValidatorUtil(DocumentValidationContext documentValidationContext, Configuration config, ValidationPolicyType policyFromRequest) {
        this.documentValidationContext = documentValidationContext;
        this.config = config;
        this.policyFromRequest = policyFromRequest;
    }

    ValidationPolicyType getPolicyForTimestampValidation(Timestamp timeStamp) {
        if (this.policyFromRequest != null) {
            return this.policyFromRequest;
        }
        PolicyProviderManager policyManagerProvider = this.config.getPolicyProviderManager();
        return new PolicyDeterminator(policyManagerProvider).process(timeStamp);
    }

    private Optional<ValidationData> getValidationDataFromRequestOptions() {
        return Optional.ofNullable(this.documentValidationContext).map(DocumentValidationContext::getOptions).map(ValidationOptions::getValidationData);
    }

    void extendContextWithValidationDataFromRequest(SignatureValidationContext context) {
        this.getValidationDataFromRequestOptions().ifPresent(x -> this.extendContextWithValidationData(context, (ValidationData)x));
    }

    private void extendContextWithValidationData(SignatureValidationContext context, ValidationData validationData) {
        ContextUtil.extendContextWithCertificates(context, validationData.getCertificates(), InformationSource.REQUEST);
        ContextUtil.extendContextWithRevocationValues(context, validationData.getOCSPValues(), validationData.getCRLs(), InformationSource.REQUEST);
    }

    void addPOEsFromRequest(List<TypedDate> possibleAlgoPOEs) {
        this.getValidationDataFromRequestOptions().map(ValidationData::getDocumentPOEs).ifPresent(possibleAlgoPOEs::addAll);
    }

    DateType getDateTypeForTimestampQuality(TimestampQuality timestampQuality) {
        DateType poeLevel;
        if (timestampQuality == null) {
            return DateType.TSA;
        }
        switch (timestampQuality) {
            case QTST_EUMS_TL: 
            case NO_QTST_EUMS_TL: {
                poeLevel = DateType.QTST;
                break;
            }
            case TSA_TSS_QC_EUMS_TL: 
            case NO_TSA_TSS_QC_EUMS_TL: {
                poeLevel = DateType.TSS_QC;
                break;
            }
            case TSA_TSS_AdES_QC_AND_QES_EUMS_TL: 
            case NO_TSA_TSS_AdES_QC_AND_QES_EUMS_TL: {
                poeLevel = DateType.TSS_ADES_QC_AND_QES;
                break;
            }
            default: {
                poeLevel = DateType.TSA;
            }
        }
        return poeLevel;
    }
}

