/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.request.ObjectToValidateVisitor;
import de.governikus.csl.request.ObjectToValidateWalker;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.DocketCreator;
import de.governikus.csl.validation.test.PrefetchingContentTimeStampValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureArchiveTimeStampValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureCertificateValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignatureEvidenceRecordValidator;
import de.governikus.csl.validation.test.PrefetchingSignaturePossiblePOEValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureTimeStampValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureValidatorUtil;
import de.governikus.csl.validation.test.ValidationDocket;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrefetchingSignatureValidator {
    private PrefetchingSignatureArchiveTimeStampValidator archiveTimeStampValidator;
    private PrefetchingSignatureEvidenceRecordValidator evidenceRecordValidator;
    private PrefetchingContentTimeStampValidator contentTimeStampValidator;
    private PrefetchingSignatureTimeStampValidator timeStampValidator;
    private PrefetchingSignaturePossiblePOEValidator possiblePOEValidator;
    private PrefetchingSignatureCertificateValidator certificateValidator;

    public PrefetchingSignatureValidator(Date validationDate, DocumentValidationContext documentValidationContext, EvaluatingPolicyReferenceManager policyManager, Configuration config, ValidationPolicyType requestPolicy) {
        TypedDate validationDatePOE = SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE);
        PrefetchingSignatureContext prefetchingContext = new PrefetchingSignatureContext(validationDate, validationDatePOE, documentValidationContext, policyManager, config, requestPolicy);
        PrefetchingSignatureValidatorUtil util = new PrefetchingSignatureValidatorUtil(documentValidationContext, config, requestPolicy);
        this.possiblePOEValidator = new PrefetchingSignaturePossiblePOEValidator(prefetchingContext, util);
        this.certificateValidator = new PrefetchingSignatureCertificateValidator(prefetchingContext);
        this.archiveTimeStampValidator = new PrefetchingSignatureArchiveTimeStampValidator(prefetchingContext, util, this.possiblePOEValidator);
        this.contentTimeStampValidator = new PrefetchingContentTimeStampValidator(prefetchingContext, util);
        this.timeStampValidator = new PrefetchingSignatureTimeStampValidator(prefetchingContext, util, this.possiblePOEValidator);
        this.evidenceRecordValidator = new PrefetchingSignatureEvidenceRecordValidator(prefetchingContext, this.timeStampValidator);
    }

    public Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> process(ObjectToValidate<?> document) {
        ObjectToValidateWalker walker = new ObjectToValidateWalker();
        DocketCreator visitor = new DocketCreator();
        walker.walkObject(document, (ObjectToValidateVisitor)visitor);
        List docketsAsList = visitor.getDocketsAsList();
        this.process(docketsAsList);
        return visitor.getDockets();
    }

    public <T extends Signature, R extends SignatureValidationResult> void process(List<ValidationDocket<T, R>> dockets) {
        dockets.stream().forEach(this.archiveTimeStampValidator::processArchiveTimestamps);
        dockets.stream().forEach(this.evidenceRecordValidator::processEvidenceRecords);
        dockets.stream().forEach(this.contentTimeStampValidator::processContentTimestamps);
        List<ValidationDocket<Timestamp, TimestampValidationResult>> timestampDockets = dockets.stream().map(ValidationDocket::getTimestamps).filter(t -> t != null && !t.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
        this.timeStampValidator.processSignatureTimestamps(timestampDockets);
        this.possiblePOEValidator.processPossiblePOEs(dockets);
        this.certificateValidator.processCertificates(dockets);
    }
}

