/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignaturePossiblePOEValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureValidatorUtil;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.TSPPlugin;
import java.util.List;

public class PrefetchingSignatureTimeStampValidator {
    private PrefetchingSignatureContext prefetchingContext;
    private PrefetchingSignatureValidatorUtil util;
    private PrefetchingSignaturePossiblePOEValidator possiblePOEValidator;

    public PrefetchingSignatureTimeStampValidator(PrefetchingSignatureContext prefetchingContext, PrefetchingSignatureValidatorUtil util, PrefetchingSignaturePossiblePOEValidator possiblePOEValidator) {
        this.prefetchingContext = prefetchingContext;
        this.util = util;
        this.possiblePOEValidator = possiblePOEValidator;
    }

    void processSignatureTimestamps(List<ValidationDocket<Timestamp, TimestampValidationResult>> timestampDockets) {
        if (timestampDockets == null || timestampDockets.isEmpty()) {
            return;
        }
        this.possiblePOEValidator.processPossiblePOEs(timestampDockets);
        TSPPlugin tspPlugin = new TSPPlugin();
        List allKnownCustomPlugins = TSPPlugin.getAllKnownCustomPlugins();
        for (ValidationDocket tspDocket : timestampDockets) {
            Timestamp tst = (Timestamp)tspDocket.getSignature();
            ValidationPolicyType policy = this.util.getPolicyForTimestampValidation(tst);
            SignatureValidationContext context = tspPlugin.createContext(tst, policy);
            context.setDocumentValidationContext(this.prefetchingContext.getDocumentValidationContext());
            context.setConfiguration(this.prefetchingContext.getConfig());
            context.extendContext((Signature)tst, this.prefetchingContext.getValidationDate(), (ValidatePolicy)policy);
            context.setBestSigningTime(BestPOEDeterminator.getBestPOE(tspDocket.getPossiblePOEs(), (ValidatePolicy)policy, true));
            context.setBestAlgValidationTime(BestPOEDeterminator.getBestPOEForAlgorithmValidity(tspDocket.getPossibleAlgValidationTimes(), (ValidatePolicy)policy));
            this.util.extendContextWithValidationDataFromRequest(context);
            SignatureValidator tstValidator = tspPlugin.createSignatureValidator(tst, context, allKnownCustomPlugins);
            TimestampValidationResult validateSignature = (TimestampValidationResult)tstValidator.validateSignature();
            int policyRef = this.prefetchingContext.getPolicyManager().addPolicy(policy, this.prefetchingContext.getPolicyFromRequest() == null ? PolicyOrigin.AUTOMATIC_DETERMINATION : PolicyOrigin.REQUEST);
            validateSignature.setPolicyReference(policyRef);
            tspDocket.setSignatureValidationResult(validateSignature);
        }
    }
}

