/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampChainValidationResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignatureValidatorUtil;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.ArchiveTimestamp;
import de.governikus.csl.validation.tsp.ArchiveTimestampResponseEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class PrefetchingSignaturePossiblePOEValidator {
    private PrefetchingSignatureContext prefetchingContext;
    private PrefetchingSignatureValidatorUtil util;

    public PrefetchingSignaturePossiblePOEValidator(PrefetchingSignatureContext prefetchingContext, PrefetchingSignatureValidatorUtil util) {
        this.prefetchingContext = prefetchingContext;
        this.util = util;
    }

    <T extends Signature, R extends SignatureValidationResult> void processPossiblePOEs(List<ValidationDocket<T, R>> dockets) {
        for (ValidationDocket<T, R> docket : dockets) {
            ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
            ArrayList<TypedDate> possibleAlgValidationTimes = new ArrayList<TypedDate>();
            possiblePOEs.add(this.prefetchingContext.getValidationDatePOE());
            possibleAlgValidationTimes.add(this.prefetchingContext.getValidationDatePOE());
            TypedDate signingTime = docket.getSignature().getSigningTime();
            if (signingTime != null) {
                possiblePOEs.add(signingTime);
            }
            this.util.addPOEsFromRequest(possiblePOEs);
            this.util.addPOEsFromRequest(possibleAlgValidationTimes);
            this.addPOEsFromTimestamps(docket, possiblePOEs);
            if (docket.getEvidenceRecordValidationResults() != null) {
                docket.getEvidenceRecordValidationResults().stream().filter(recResult -> !this.isDataProtectedByEvidenceRecord((EvidenceRecordValidationResult)recResult)).forEach(recResult -> this.addPOEsFromEvidenceRecord((EvidenceRecordValidationResult)recResult, (List<TypedDate>)possiblePOEs, (List<TypedDate>)possibleAlgValidationTimes));
            }
            this.addPOEsFromArchiveTimestamps(docket, possiblePOEs, possibleAlgValidationTimes);
            docket.setPossiblePOEs(possiblePOEs);
            docket.setPossibleAlgValidationTimes(possibleAlgValidationTimes);
        }
    }

    private void addPOEsFromTimestamps(ValidationDocket<?, ?> docket, List<TypedDate> possiblePOEs) {
        List<ValidationDocket<Timestamp, TimestampValidationResult>> timestamps = docket.getTimestamps();
        if (timestamps != null) {
            for (ValidationDocket<Timestamp, TimestampValidationResult> tsp : timestamps) {
                TimestampValidationResult tspResult = (TimestampValidationResult)tsp.getSignatureValidationResult();
                CumulatedValidationResult overallResult = tspResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
                if (overallResult.getMajor() != MajorTotalResult.TOTAL_PASSED) continue;
                TimestampQuality timestampQuality = tspResult.getTimestampQuality();
                DateType poeLevel = this.util.getDateTypeForTimestampQuality(timestampQuality);
                possiblePOEs.add(SVPFactory.createTypedDate((Date)tspResult.getGenerationTime(), (DateType)poeLevel));
            }
        }
    }

    private boolean isDataProtectedByEvidenceRecord(EvidenceRecordValidationResult evidenceRecordResult) {
        List timestampChainResponses = evidenceRecordResult.getTimestampChainResponses();
        if (timestampChainResponses == null || timestampChainResponses.isEmpty()) {
            return false;
        }
        ERArchiveTimestampChainValidationResult firstTimestampChainResult = (ERArchiveTimestampChainValidationResult)timestampChainResponses.get(0);
        List timestampResponses = firstTimestampChainResult.getTimestampResponses();
        if (timestampResponses == null || timestampResponses.isEmpty()) {
            return false;
        }
        ERArchiveTimestampValidationResult firstArchiveTimestampResult = (ERArchiveTimestampValidationResult)timestampResponses.get(0);
        ERHashTreeValidationResult hashTreeValidationResult = firstArchiveTimestampResult.getHashTreeValidationResult();
        if (hashTreeValidationResult == null) {
            return false;
        }
        return hashTreeValidationResult.isDataCovered();
    }

    private void addPOEsFromEvidenceRecord(EvidenceRecordValidationResult atSeq, List<TypedDate> possiblePOEs, List<TypedDate> possibleAlgValidationTimes) {
        List timestampChainResponses = atSeq.getTimestampChainResponses();
        Date min = null;
        DateType minPoeLevel = null;
        for (ERArchiveTimestampChainValidationResult chainResp : timestampChainResponses) {
            List timestampResponses = chainResp.getTimestampResponses();
            for (ERArchiveTimestampValidationResult atResp : timestampResponses) {
                TimestampValidationResult timestampTokenValidationResult = atResp.getTimestampTokenValidationResult();
                CumulatedValidationResult overallResult = timestampTokenValidationResult.getOverallResult(true);
                if (overallResult.getMajor() != MajorTotalResult.TOTAL_PASSED) {
                    return;
                }
                Date generationTime = timestampTokenValidationResult.getGenerationTime();
                if (min == null || generationTime.before(min)) {
                    min = generationTime;
                }
                TimestampQuality timestampQuality = timestampTokenValidationResult.getTimestampQuality();
                DateType tmpPOELevel = this.util.getDateTypeForTimestampQuality(timestampQuality);
                if (minPoeLevel != null && minPoeLevel.compareTo((Enum)tmpPOELevel) <= 0) continue;
                minPoeLevel = tmpPOELevel;
            }
        }
        TypedDate poe = SVPFactory.createTypedDate(min, minPoeLevel);
        possiblePOEs.add(poe);
        possibleAlgValidationTimes.add(poe);
    }

    protected void addPOEsFromArchiveTimestamps(ValidationDocket<?, ?> docket, List<TypedDate> possiblePOEs, List<TypedDate> possibleAlgValidationTimes) {
        List<ArchiveTimestampResponseEntry> archiveTimestampValidationResults = docket.getArchiveTimestampValidationResults();
        this.addPOEsFromArchiveTimestamps((Signature)docket.getSignature(), archiveTimestampValidationResults, possiblePOEs, possibleAlgValidationTimes, x -> true);
    }

    void addPOEsFromArchiveTimestamps(Signature signature, List<ArchiveTimestampResponseEntry> archiveTimestampValidationResults, List<TypedDate> possiblePOEs, List<TypedDate> possibleAlgValidationTimes, Predicate<ArchiveTimestamp> protectsSignatureFilter) {
        if (archiveTimestampValidationResults == null || archiveTimestampValidationResults.isEmpty()) {
            return;
        }
        List attachedOCSPValues = signature.getAttachedOCSPValues();
        List attachedCRLs = signature.getAttachedCRLs();
        Set attachedCertificates = signature.getAttachedCertificates();
        for (ArchiveTimestampResponseEntry entry : archiveTimestampValidationResults) {
            ArchiveTimestamp ts = entry.getTimestamp();
            ArchiveTimestampValidationResult tsvr = entry.getValidationResult();
            CumulatedValidationResult overallResult = tsvr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
            if (overallResult.getMajor() != MajorTotalResult.TOTAL_PASSED || !protectsSignatureFilter.test(ts)) continue;
            TimestampQuality timestampQuality = tsvr.getTimestampQuality();
            DateType poeLevel = this.util.getDateTypeForTimestampQuality(timestampQuality);
            TypedDate poe = SVPFactory.createTypedDate((Date)tsvr.getGenerationTime(), (DateType)poeLevel);
            possiblePOEs.add(poe);
            possibleAlgValidationTimes.add(poe);
            if (attachedOCSPValues != null) {
                this.addPOEIfAnyProtectedByThisArchiveTimeStamp(attachedOCSPValues, poe, ts::isOCSPValueProtected);
            }
            if (attachedCRLs != null) {
                this.addPOEIfAnyProtectedByThisArchiveTimeStamp(attachedCRLs, poe, ts::isCRLProtected);
            }
            if (attachedCertificates == null) continue;
            this.addPOEIfAnyProtectedByThisArchiveTimeStamp(attachedCertificates, poe, ts::isCertProtected);
        }
    }

    private <T> void addPOEIfAnyProtectedByThisArchiveTimeStamp(Collection<SignatureValidationDataAttachment<T>> attachments, TypedDate poe, Predicate<SignatureValidationDataAttachment<T>> protectionChecker) {
        attachments.stream().filter(protectionChecker).forEach(attachment -> attachment.addPOE(poe));
    }
}

