/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.validate.svp.EvaluatedPolicyEntry;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.er.ArchiveTimestampChainValidator;
import de.governikus.csl.validation.er.ArchiveTimestampTokenValidationResult;
import de.governikus.csl.validation.er.ArchiveTimestampValidator;
import de.governikus.csl.validation.er.EvidenceRecord;
import de.governikus.csl.validation.er.EvidenceRecordValidator;
import de.governikus.csl.validation.er.ReducedHashTreeDigestAlgorithmValidator;
import de.governikus.csl.validation.er.ReducedHashTreeValidator;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignatureTimeStampValidator;
import de.governikus.csl.validation.test.ValidationDocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class PrefetchingSignatureEvidenceRecordValidator {
    private PrefetchingSignatureContext prefetchingContext;
    private PrefetchingSignatureTimeStampValidator timeStampValidator;

    public PrefetchingSignatureEvidenceRecordValidator(PrefetchingSignatureContext prefetchingContext, PrefetchingSignatureTimeStampValidator timeStampValidator) {
        this.prefetchingContext = prefetchingContext;
        this.timeStampValidator = timeStampValidator;
    }

    public void processEvidenceRecords(ValidationDocket<?, ?> docket) {
        List<EvidenceRecord> evidenceRecords = docket.getEvidenceRecords();
        if (evidenceRecords == null) {
            return;
        }
        ReducedHashTreeDigestAlgorithmValidator digestAlgorithmValidator = new ReducedHashTreeDigestAlgorithmValidator(this.prefetchingContext.getConfig().getAlgorithmCatalog());
        ArchiveTimestampValidator archiveTimestampValidator = new ArchiveTimestampValidator(this::validateEvidenceRecordTimestampToken, new ReducedHashTreeValidator(), digestAlgorithmValidator);
        ArchiveTimestampChainValidator archiveTimestampChainValidator = new ArchiveTimestampChainValidator(archiveTimestampValidator);
        EvidenceRecordValidator validator = new EvidenceRecordValidator(archiveTimestampChainValidator);
        ArrayList<EvidenceRecordValidationResult> resp = new ArrayList<EvidenceRecordValidationResult>();
        for (EvidenceRecord er : evidenceRecords) {
            EvidenceRecordValidationResult res = validator.validate(er, new Date());
            resp.add(res);
        }
        docket.setEvidenceRecordValidationResults(resp);
    }

    private ArchiveTimestampTokenValidationResult validateEvidenceRecordTimestampToken(WritableTimestamp<?> timestamp, byte[] messageDigest, Date validationDate) {
        timestamp.setTimestampedContentHash(messageDigest);
        ValidationDocket docket = new ValidationDocket();
        docket.setSignature(timestamp);
        docket.setSigningCertificate(timestamp.getSigningCertificate());
        this.timeStampValidator.processSignatureTimestamps(Collections.singletonList(docket));
        TimestampValidationResult signatureValidationResult = (TimestampValidationResult)docket.getSignatureValidationResult();
        Optional policy = this.prefetchingContext.getPolicyManager().getPolicyById(signatureValidationResult.getPolicyReference());
        return new ArchiveTimestampTokenValidationResult(signatureValidationResult, policy.map(EvaluatedPolicyEntry::getPolicy).map(EvaluatedValidationPolicyType::getPolicy).orElse(null));
    }
}

