/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.NonValidatingCertValidator;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class PrefetchingSignatureCertificateValidator {
    private PrefetchingSignatureContext prefetchingContext;

    public PrefetchingSignatureCertificateValidator(PrefetchingSignatureContext prefetchingContext) {
        this.prefetchingContext = prefetchingContext;
    }

    public <T extends Signature, R extends SignatureValidationResult> void processCertificates(List<ValidationDocket<T, R>> validationDockets) {
        CertificateValidator certValidator;
        DocumentValidationContext documentValidationContext = this.prefetchingContext.getDocumentValidationContext();
        if (this.prefetchingContext.getPolicyFromRequest() != null && Boolean.TRUE.equals(this.prefetchingContext.getPolicyFromRequest().isCertificateValidationDisabled())) {
            PolicyProviderManager policyProviderManager = documentValidationContext.getPolicyManager().getPolicyProviderManager();
            certValidator = new NonValidatingCertValidator(policyProviderManager);
        } else {
            certValidator = this.prefetchingContext.getConfig().getCertValidator();
        }
        certValidator.prefetchCertificateValidation(validationDockets, this.prefetchingContext.getPolicyFromRequest(), documentValidationContext.getOptions());
        Map<X509Certificate, PublicKeyCertificateValidationResult> prefetchedCertificateValidationResults = this.initializedMapIfRequired(documentValidationContext.getPrefetchedCertificateValidationResults(), documentValidationContext::setPrefetchedCertificateValidationResults);
        Map<AttributeCertificate, AttributeCertificateValidationResult> prefetchedAttributeCertificateValidationResults = this.initializedMapIfRequired(documentValidationContext.getPrefetchedAttributeCertificateValidationResults(), documentValidationContext::setPrefetchedAttributeCertificateValidationResults);
        for (ValidationDocket docket : validationDockets) {
            List<CertChainResult<AttributeCertificateValidationResult>> attributeCertificateValidationResults;
            CertChainResult<PublicKeyCertificateValidationResult> signingCertificateValidationResult = docket.getSigningCertificateValidationResult();
            if (signingCertificateValidationResult != null) {
                prefetchedCertificateValidationResults.put((X509Certificate)docket.getSigningCertificate(), signingCertificateValidationResult.getCertificateValidationResult());
            }
            if ((attributeCertificateValidationResults = docket.getAttributeCertificateValidationResults()) == null) continue;
            for (CertChainResult<AttributeCertificateValidationResult> ca : attributeCertificateValidationResults) {
                AttributeCertificateValidationResult certificateValidationResult = ca.getCertificateValidationResult();
                prefetchedAttributeCertificateValidationResults.put((AttributeCertificate)certificateValidationResult.getCert().getWrappedCertificate(), certificateValidationResult);
            }
        }
    }

    private <K, V extends CertificateValidationResult> Map<K, V> initializedMapIfRequired(Map<K, V> map, Consumer<Map<K, V>> setter) {
        if (map == null) {
            map = new HashMap();
            setter.accept(map);
        }
        return map;
    }
}

