/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.SignatureValidatorImpl;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignaturePossiblePOEValidator;
import de.governikus.csl.validation.test.PrefetchingSignatureValidatorUtil;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.ArchiveTimestamp;
import de.governikus.csl.validation.tsp.ArchiveTimestampResponseEntry;
import de.governikus.csl.validation.tsp.ArchiveTimestampValidationInitializer;
import de.governikus.csl.validation.tsp.TSPPlugin;
import java.util.ArrayList;
import java.util.List;

public class PrefetchingSignatureArchiveTimeStampValidator {
    private PrefetchingSignatureContext prefetchingContext;
    private PrefetchingSignatureValidatorUtil util;
    private PrefetchingSignaturePossiblePOEValidator possiblePOEValidator;

    public PrefetchingSignatureArchiveTimeStampValidator(PrefetchingSignatureContext prefetchingContext, PrefetchingSignatureValidatorUtil util, PrefetchingSignaturePossiblePOEValidator possiblePOEValidator) {
        this.prefetchingContext = prefetchingContext;
        this.util = util;
        this.possiblePOEValidator = possiblePOEValidator;
    }

    public void processArchiveTimestamps(ValidationDocket<? extends Signature, ?> docket) {
        List<ArchiveTimestamp> archiveTimestamps = docket.getArchiveTimestamps();
        if (archiveTimestamps == null || archiveTimestamps.isEmpty()) {
            return;
        }
        ArrayList<ArchiveTimestampResponseEntry> archiveTimestampValidationResults = new ArrayList<ArchiveTimestampResponseEntry>();
        ArchiveTimestamp last = null;
        ArchiveTimestampValidationResult lastResult = null;
        for (int i = archiveTimestamps.size() - 1; i >= 0; --i) {
            ArchiveTimestamp archiveTimestamp = archiveTimestamps.get(i);
            ArchiveTimestampValidationResult archiveTimestampValidationResult = this.validateArchiveTimestamp(archiveTimestamp, archiveTimestampValidationResults);
            archiveTimestampValidationResult.setRefID("ArchiveTimestamp#" + (i + 1));
            if (last != null && archiveTimestamp.isProtectedBy(last)) {
                archiveTimestampValidationResult.getSecuredBy().add(lastResult.getRefID());
            }
            ArchiveTimestampResponseEntry archiveTimestampResponseEntry = new ArchiveTimestampResponseEntry(archiveTimestamp, archiveTimestampValidationResult);
            archiveTimestampValidationResults.add(archiveTimestampResponseEntry);
            last = archiveTimestamp;
            lastResult = archiveTimestampValidationResult;
            this.addArchiveTimestampResultToSignatureTimestamps(archiveTimestampResponseEntry, docket.getTimestamps(), (Signature)docket.getSignature());
        }
        docket.setArchiveTimestampValidationResults(archiveTimestampValidationResults);
    }

    private ArchiveTimestampValidationResult validateArchiveTimestamp(ArchiveTimestamp timestamp, List<ArchiveTimestampResponseEntry> archiveTimestampValidationResults) {
        TSPPlugin tspPlugin = new TSPPlugin();
        ArrayList customValidations = new ArrayList(TSPPlugin.getAllKnownCustomPlugins());
        customValidations.addAll(timestamp.getCustomPlugins());
        ValidationPolicyType policy = this.util.getPolicyForTimestampValidation(timestamp);
        SignatureValidationContext context = tspPlugin.createContext(timestamp, policy);
        context.setDocumentValidationContext(this.prefetchingContext.getDocumentValidationContext());
        context.setConfiguration(this.prefetchingContext.getConfig());
        context.setValidationDate(this.prefetchingContext.getValidationDate());
        context.extendContext((Signature)timestamp, this.prefetchingContext.getValidationDate(), (ValidatePolicy)policy);
        this.util.extendContextWithValidationDataFromRequest(context);
        ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
        ArrayList<TypedDate> possibleAlgoPOEs = new ArrayList<TypedDate>();
        this.util.addPOEsFromRequest(possiblePOEs);
        this.util.addPOEsFromRequest(possibleAlgoPOEs);
        possiblePOEs.add(this.prefetchingContext.getValidationDatePOE());
        possibleAlgoPOEs.add(this.prefetchingContext.getValidationDatePOE());
        possiblePOEs.add(timestamp.getSigningTime());
        this.possiblePOEValidator.addPOEsFromArchiveTimestamps((Signature)timestamp, archiveTimestampValidationResults, possiblePOEs, possibleAlgoPOEs, timestamp::isProtectedBy);
        TypedDate bestAlgoPOE = BestPOEDeterminator.getBestPOEForAlgorithmValidity(possibleAlgoPOEs, (ValidatePolicy)policy);
        context.setBestAlgValidationTime(bestAlgoPOE);
        TypedDate bestPOE = BestPOEDeterminator.getBestPOE(possiblePOEs, (ValidatePolicy)policy);
        context.setBestSigningTime(bestPOE);
        SignatureValidatorImpl<ArchiveTimestamp, ArchiveTimestampValidationResult, SignatureValidationContext> signatureValidator = new SignatureValidatorImpl<ArchiveTimestamp, ArchiveTimestampValidationResult, SignatureValidationContext>(new ArchiveTimestampValidationInitializer(), timestamp, context);
        signatureValidator.setCustomCriteria(customValidations);
        ArchiveTimestampValidationResult validateSignature = signatureValidator.validateSignature();
        int policyReference = this.prefetchingContext.getPolicyManager().addPolicy(policy, this.prefetchingContext.getPolicyFromRequest() == null ? PolicyOrigin.AUTOMATIC_DETERMINATION : PolicyOrigin.REQUEST);
        validateSignature.setPolicyReference(policyReference);
        return validateSignature;
    }

    private void addArchiveTimestampResultToSignatureTimestamps(ArchiveTimestampResponseEntry archiveTimestampResponseEntry, List<ValidationDocket<Timestamp, TimestampValidationResult>> timestampDockets, Signature signature) {
        if (timestampDockets == null || timestampDockets.isEmpty()) {
            return;
        }
        ArchiveTimestamp archiveTimestamp = archiveTimestampResponseEntry.getTimestamp();
        for (ValidationDocket<Timestamp, TimestampValidationResult> currentDocket : timestampDockets) {
            Timestamp timstamp = (Timestamp)currentDocket.getSignature();
            if (!archiveTimestamp.isSignatureTimestampProtected(timstamp, signature)) continue;
            List<ArchiveTimestampResponseEntry> archiveTimestampValidationResults = currentDocket.getArchiveTimestampValidationResults();
            if (archiveTimestampValidationResults == null) {
                archiveTimestampValidationResults = new ArrayList<ArchiveTimestampResponseEntry>();
                currentDocket.setArchiveTimestampValidationResults(archiveTimestampValidationResults);
            }
            archiveTimestampValidationResults.add(archiveTimestampResponseEntry);
        }
    }
}

