/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.PrefetchingSignatureContext;
import de.governikus.csl.validation.test.PrefetchingSignatureValidatorUtil;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.TSPPlugin;
import java.util.ArrayList;
import java.util.List;

public class PrefetchingContentTimeStampValidator {
    private PrefetchingSignatureContext prefetchingContext;
    private PrefetchingSignatureValidatorUtil util;

    public PrefetchingContentTimeStampValidator(PrefetchingSignatureContext prefetchingContext, PrefetchingSignatureValidatorUtil util) {
        this.prefetchingContext = prefetchingContext;
        this.util = util;
    }

    void processContentTimestamps(ValidationDocket<?, ?> timestampDocket) {
        List<Timestamp> contentTimestamps = timestampDocket.getContentTimestamps();
        if (contentTimestamps == null || contentTimestamps.isEmpty()) {
            return;
        }
        TSPPlugin tspPlugin = new TSPPlugin();
        List allKnownCustomPlugins = TSPPlugin.getAllKnownCustomPlugins();
        ArrayList<TimestampValidationResult> contentTimestampValidationResults = new ArrayList<TimestampValidationResult>();
        for (Timestamp tst : contentTimestamps) {
            ValidationPolicyType policy = this.util.getPolicyForTimestampValidation(tst);
            SignatureValidationContext context = tspPlugin.createContext(tst, policy);
            context.setDocumentValidationContext(this.prefetchingContext.getDocumentValidationContext());
            context.setConfiguration(this.prefetchingContext.getConfig());
            context.extendContext((Signature)tst, this.prefetchingContext.getValidationDate(), (ValidatePolicy)policy);
            context.setBestSigningTime(BestPOEDeterminator.getBestPOE(timestampDocket.getPossiblePOEs(), (ValidatePolicy)policy, true));
            context.setBestAlgValidationTime(BestPOEDeterminator.getBestPOEForAlgorithmValidity(timestampDocket.getPossibleAlgValidationTimes(), (ValidatePolicy)policy));
            this.util.extendContextWithValidationDataFromRequest(context);
            SignatureValidator tstValidator = tspPlugin.createSignatureValidator(tst, context, allKnownCustomPlugins);
            TimestampValidationResult validatedTst = (TimestampValidationResult)tstValidator.validateSignature();
            int policyRef = this.prefetchingContext.getPolicyManager().addPolicy(policy, this.prefetchingContext.getPolicyFromRequest() == null ? PolicyOrigin.AUTOMATIC_DETERMINATION : PolicyOrigin.REQUEST);
            validatedTst.setPolicyReference(policyRef);
            contentTimestampValidationResults.add(validatedTst);
        }
        timestampDocket.setContentTimestampValidationResult(contentTimestampValidationResults);
    }
}

