/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.test;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.request.ObjectToValidateVisitor;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.er.ERS;
import de.governikus.csl.validation.test.ValidationDocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocketCreator
extends ObjectToValidateVisitor {
    private Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> dockets = new HashMap<Signature, ValidationDocket<Signature, SignatureValidationResult>>();
    private List<ValidationDocket<Signature, SignatureValidationResult>> docketsAsList = new ArrayList<ValidationDocket<Signature, SignatureValidationResult>>();
    private ValidationDocket<Signature, SignatureValidationResult> current = null;

    public void startVisitingSignature(Signature sig) {
        this.current = this.createDocket(SignatureValidationResult.class, sig);
        this.dockets.put(sig, this.current);
        this.docketsAsList.add(this.current);
    }

    public void stopVisitingSignature(Signature sig) {
        this.current = null;
    }

    public void startVisitingSignatureTimestamp(Timestamp tst) {
        List<ValidationDocket<Timestamp, TimestampValidationResult>> timestampList = this.current.getTimestamps();
        if (timestampList == null) {
            timestampList = new ArrayList<ValidationDocket<Timestamp, TimestampValidationResult>>();
            this.current.setTimestamps(timestampList);
        }
        this.current.getTimestamps().add(this.createDocket(TimestampValidationResult.class, tst));
    }

    public void startVisitingDataTimestamp(Timestamp tst) {
        List<Timestamp> contentTimestampList = this.current.getContentTimestamps();
        if (contentTimestampList == null) {
            contentTimestampList = new ArrayList<Timestamp>();
            this.current.setContentTimestamps(contentTimestampList);
        }
        this.current.getContentTimestamps().add(tst);
    }

    private <T extends Signature, R extends SignatureValidationResult> ValidationDocket<T, R> createDocket(Class<R> type, T sig) {
        ValidationDocket docket = new ValidationDocket();
        docket.setSignature(sig);
        docket.setSigningCertificate(sig.getSigningCertificate());
        docket.setAttributeCertificates(sig.getAttributeCertificates());
        if (sig instanceof AdESSignature) {
            AdESSignature adesSignature = (AdESSignature)sig;
            docket.setEvidenceRecords(adesSignature.getEvidenceRecords());
            docket.setArchiveTimestamps(adesSignature.getArchiveTimestamps());
        } else if (sig instanceof ERS) {
            ERS ers = (ERS)sig;
            docket.setEvidenceRecords(Collections.singletonList(ers.getEvidenceRecord()));
        }
        return docket;
    }

    public Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> getDockets() {
        return this.dockets;
    }

    public List<ValidationDocket<Signature, SignatureValidationResult>> getDocketsAsList() {
        return this.docketsAsList;
    }
}

