/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.util.ArrayList;
import java.util.List;

public class WrappingRevocationValueService
implements RevocationValueService {
    private RevocationValueService[] services;

    public WrappingRevocationValueService(RevocationValueService ... services) {
        this.services = services;
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        ArrayList valMsgCodes = new ArrayList();
        for (RevocationValueService rvs : this.services) {
            RevocationValue rv = rvs.getRevocationValue(so, context, onlyOCSP);
            if (rv == null) continue;
            List valMsgCodesTmp = rv.getValidationMessageCodes();
            if (rv.hasNoValidationMessages()) {
                return rv;
            }
            valMsgCodes.addAll(valMsgCodesTmp);
        }
        if (!valMsgCodes.isEmpty()) {
            RevocationValue defaultRv = new RevocationValue();
            defaultRv.setValidationMessageCodes(valMsgCodes);
            return defaultRv;
        }
        return null;
    }
}

